/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.copy.CopyFormatAction;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MGraphicElementLinePen;
import com.jaspersoft.studio.model.MLineBox;
import com.jaspersoft.studio.model.MLinePen;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class PasteFormatCommand
extends Command {
    protected JSSCompoundCommand executedCommands;
    protected List<APropertyNode> editedNodes;

    public PasteFormatCommand(List<APropertyNode> editedNodes) {
        this.editedNodes = editedNodes;
        this.executedCommands = null;
    }

    public boolean canExecute() {
        return !this.editedNodes.isEmpty() && CopyFormatAction.hasCopiedValues();
    }

    public void execute() {
        this.executedCommands = new JSSCompoundCommand(this.editedNodes.get(0));
        for (APropertyNode node : this.editedNodes) {
            this.generateCommandsForNode(node, this.executedCommands);
        }
        this.executedCommands.execute();
    }

    private void generateCommandsForNode(APropertyNode node, JSSCompoundCommand commands) {
        String[] stringArray = CopyFormatAction.propertyNames;
        int n = CopyFormatAction.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propString = stringArray[n2];
            Object copiedValue = CopyFormatAction.getCopiedValue(propString);
            SetValueCommand setCommand = new SetValueCommand();
            setCommand.setTarget(node);
            setCommand.setPropertyId(propString);
            setCommand.setPropertyValue(copiedValue);
            commands.add(setCommand);
            if (node instanceof MGraphicElementLinePen) {
                MGraphicElementLinePen penNode = (MGraphicElementLinePen)node;
                MLinePen linePen = penNode.getLinePen();
                this.generateCommandsForLinePen("LinePen", linePen, commands);
            }
            if (node instanceof MGraphicElementLineBox) {
                MGraphicElementLineBox boxNode = (MGraphicElementLineBox)node;
                MLineBox lineBox = boxNode.getLineBox();
                this.generateCommandsForLinePen("LinePen", (MLinePen)lineBox.getPropertyValue("LinePen"), commands);
                this.generateCommandsForLinePen("LinePen_BOTTOM", (MLinePen)lineBox.getPropertyValue("LinePen_BOTTOM"), commands);
                this.generateCommandsForLinePen("LinePen_LEFT", (MLinePen)lineBox.getPropertyValue("LinePen_LEFT"), commands);
                this.generateCommandsForLinePen("LinePen_RIGHT", (MLinePen)lineBox.getPropertyValue("LinePen_RIGHT"), commands);
                this.generateCommandsForLinePen("LinePen_TOP", (MLinePen)lineBox.getPropertyValue("LinePen_TOP"), commands);
            }
            ++n2;
        }
    }

    private void generateCommandsForLinePen(String prefix, MLinePen node, JSSCompoundCommand commands) {
        SetValueCommand setCommand = new SetValueCommand();
        setCommand.setTarget(node);
        setCommand.setPropertyId("lineColor");
        setCommand.setPropertyValue(CopyFormatAction.getCopiedValue(String.valueOf(prefix) + "lineColor"));
        commands.add(setCommand);
        setCommand = new SetValueCommand();
        setCommand.setTarget(node);
        setCommand.setPropertyId("lineWidth");
        setCommand.setPropertyValue(CopyFormatAction.getCopiedValue(String.valueOf(prefix) + "lineWidth"));
        commands.add(setCommand);
        setCommand = new SetValueCommand();
        setCommand.setTarget(node);
        setCommand.setPropertyId("lineStyle");
        setCommand.setPropertyValue(CopyFormatAction.getCopiedValue(String.valueOf(prefix) + "lineStyle"));
        commands.add(setCommand);
    }

    public void redo() {
        this.executedCommands.redo();
    }

    public boolean canUndo() {
        return this.executedCommands.canUndo();
    }

    public void undo() {
        this.executedCommands.undo();
    }
}

