/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.csv;

import com.jaspersoft.studio.editor.action.csv.CSVAction;
import com.jaspersoft.studio.editor.gef.decorator.csv.ColumnNamesSettingDialog;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class CSVColSettingAction
extends CSVAction {
    private String columnNames;

    public CSVColSettingAction(IWorkbenchPart part, String actionName) {
        super(part, CSVAction.COL_NAMES, actionName);
    }

    @Override
    public boolean isChecked() {
        return false;
    }

    @Override
    public void run() {
        ColumnNamesSettingDialog dialog = new ColumnNamesSettingDialog(UIUtils.getShell(), this.getRoot().getJasperDesign());
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            this.columnNames = dialog.getColumnNames();
            this.execute(this.createCommand());
        }
    }

    @Override
    protected Command createCommand() {
        APropertyNode columnValue = this.getRoot();
        if (columnValue != null) {
            JRPropertiesMap rootMap = (JRPropertiesMap)columnValue.getPropertyValue("PROPERTY_MAP");
            if (rootMap == null) {
                rootMap = new JRPropertiesMap();
            }
            if (Misc.isNullOrEmpty((String)this.columnNames)) {
                rootMap.removeProperty("net.sf.jasperreports.export.csv.column.names");
            } else {
                rootMap.setProperty("net.sf.jasperreports.export.csv.column.names", this.columnNames);
            }
            SetValueCommand setRootNames = new SetValueCommand();
            setRootNames.setTarget((APropertyNode)columnValue.getRoot());
            setRootNames.setPropertyId("PROPERTY_MAP");
            setRootNames.setPropertyValue(rootMap);
            return setRootNames;
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        return true;
    }
}

