/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.util.CastorUtil;
import net.sf.jasperreports.util.JacksonRuntimException;
import net.sf.jasperreports.util.JacksonUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ExportedAdapterHandler
implements IExportedResourceHandler {
    private static final String EXPORTED_FOLDER_NAME = "dataAdapters";
    private static final String INDEX_FILE_NAME = "index.properties";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    @Override
    public String getResourceNameExport() {
        ADataAdapterStorage storage = DataAdapterManager.getPreferencesStorage();
        return "Data Adapters (" + storage.getDataAdapterDescriptors().size() + ")";
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        return "Data Adapters (" + this.getRestorableResources(exportedContainer).size() + ")";
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            ADataAdapterStorage storage = DataAdapterManager.getPreferencesStorage();
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            for (DataAdapterDescriptor descriptor : storage.getDataAdapterDescriptors()) {
                BaseResource resource = new BaseResource(descriptor.getName());
                resource.setData(descriptor);
                this.cachedExportableResources.add(resource);
            }
        }
        return this.cachedExportableResources;
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                File exportedFolder = new File(exportedContainer, EXPORTED_FOLDER_NAME);
                File indexFile = new File(exportedFolder, INDEX_FILE_NAME);
                if (indexFile.exists()) {
                    FileInputStream is = null;
                    try {
                        try {
                            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                            is = new FileInputStream(indexFile);
                            Properties loadedProperties = new Properties();
                            loadedProperties.load(is);
                            for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
                                BaseResource resource = new BaseResource(entry.getValue().toString());
                                resource.setData(entry.getKey());
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block8: {
            HashSet<DataAdapterDescriptor> resourcesToExportSet = new HashSet<DataAdapterDescriptor>();
            for (IResourceDefinition definition : resourcesToExport) {
                resourcesToExportSet.add((DataAdapterDescriptor)definition.getData());
            }
            ADataAdapterStorage storage = DataAdapterManager.getPreferencesStorage();
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            tempDir.deleteOnExit();
            destDir = new File(tempDir, EXPORTED_FOLDER_NAME);
            if (destDir.exists()) {
                FileUtils.recursiveDelete((File)destDir);
            }
            destDir.mkdirs();
            int index = 0;
            Properties props = new Properties();
            for (DataAdapterDescriptor descriptor : storage.getDataAdapterDescriptors()) {
                if (!resourcesToExportSet.contains(descriptor)) continue;
                String fileName = "dataAdapter" + index;
                this.save(descriptor, new File(destDir, fileName));
                props.put(fileName, descriptor.getName());
                ++index;
            }
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(destDir, INDEX_FILE_NAME));
                    props.store(out, "Exported Adapters Index");
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    FileUtils.closeStream(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        File srcDir = new File(exportedContainer, EXPORTED_FOLDER_NAME);
        if (srcDir.exists()) {
            File[] listFiles;
            HashSet<String> filesToImport = new HashSet<String>();
            for (IResourceDefinition resourceToImport : resourcesToImport) {
                filesToImport.add(resourceToImport.getData().toString());
            }
            ArrayList<File> notHiddenFiles = new ArrayList<File>();
            ArrayList<DataAdapterDescriptor> foundDataAdapters = new ArrayList<DataAdapterDescriptor>();
            File[] fileArray = listFiles = srcDir.listFiles();
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isHidden() && filesToImport.contains(f.getName())) {
                    notHiddenFiles.add(f);
                }
                ++n2;
            }
            ADataAdapterStorage storage = DataAdapterManager.getPreferencesStorage();
            for (File storageElement : notHiddenFiles) {
                this.deserializeDataAdapter(storageElement, foundDataAdapters);
            }
            Map<String, DataAdapterDescriptor> existingAdapters = storage.getDescriptors();
            ArrayList<String> duplicatedAdapters = new ArrayList<String>();
            for (DataAdapterDescriptor adapter : foundDataAdapters) {
                String name = adapter.getName().trim();
                if (!existingAdapters.containsKey(name)) continue;
                duplicatedAdapters.add(name);
            }
            RunnableOverwriteQuestion.RESPONSE_TYPE response = RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH;
            if (duplicatedAdapters.size() > 0) {
                response = this.askOverwrite(duplicatedAdapters);
            }
            for (DataAdapterDescriptor adapter : foundDataAdapters) {
                String name = adapter.getName();
                if (existingAdapters.containsKey(name)) {
                    if (response == RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH) {
                        String newName = this.getName(existingAdapters, name);
                        adapter.setName(newName);
                        adapter.getDataAdapter().setName(newName);
                        storage.addDataAdapter(adapter);
                        continue;
                    }
                    if (response != RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE) continue;
                    storage.removeDataAdapter(existingAdapters.get(name));
                    storage.addDataAdapter(adapter);
                    continue;
                }
                storage.addDataAdapter(adapter);
            }
        }
    }

    private String getName(Map<String, DataAdapterDescriptor> existingAdapters, String baseName) {
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (existingAdapters.containsKey(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }

    protected void save(DataAdapterDescriptor adapter, File destination) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(adapter.toXml((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()))));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    stream = new FileOutputStream(destination);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(stream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)stream);
        }
    }

    private void deserializeDataAdapter(File storageElement, List<DataAdapterDescriptor> foundDataAdapters) {
        block8: {
            FileInputStream inputStream;
            block7: {
                inputStream = null;
                try {
                    try {
                        Node namedItem;
                        NamedNodeMap attributes;
                        inputStream = new FileInputStream(storageElement);
                        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        InputSource is = new InputSource(reader);
                        is.setEncoding("UTF-8");
                        Document document = JRXmlUtils.parse((InputSource)is);
                        Element adapterNode = document.getDocumentElement();
                        if (adapterNode == null || (attributes = adapterNode.getAttributes()) == null || (namedItem = attributes.getNamedItem("class")) == null) break block7;
                        String adapterClassName = namedItem.getNodeValue();
                        DataAdapterFactory factory = DataAdapterManager.findFactoryByDataAdapterClass(adapterClassName);
                        if (factory == null) {
                            JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(2, JaspersoftStudioPlugin.getUniqueIdentifier(), 0, String.valueOf(Messages.DataAdapterManager_nodataadapterfound) + adapterClassName, null));
                            break block7;
                        }
                        DataAdapterDescriptor dataAdapterDescriptor = factory.createDataAdapter();
                        DataAdapter dataAdapter = dataAdapterDescriptor.getDataAdapter();
                        inputStream = new FileInputStream(storageElement);
                        try {
                            dataAdapter = (DataAdapter)JacksonUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).loadXml((InputStream)inputStream, DataAdapter.class);
                        }
                        catch (JacksonRuntimException jacksonRuntimException) {
                            ((InputStream)inputStream).close();
                            inputStream = new FileInputStream(storageElement);
                            dataAdapter = (DataAdapter)CastorUtil.getInstance((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()).read((InputStream)inputStream);
                        }
                        dataAdapterDescriptor.setDataAdapter(dataAdapter);
                        foundDataAdapters.add(dataAdapterDescriptor);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        FileUtils.closeStream((Closeable)inputStream);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(inputStream);
                    throw throwable;
                }
            }
            FileUtils.closeStream((Closeable)inputStream);
        }
    }

    private RunnableOverwriteQuestion.RESPONSE_TYPE askOverwrite(List<String> adapters) {
        String baseMessage = Messages.ExportedAdapterHandler_overlappingMessage;
        StringBuilder message = new StringBuilder("\n");
        int index = 1;
        for (String adapter : adapters) {
            message.append(adapter);
            message.append(index == adapters.size() ? ".\n" : ",\n");
            ++index;
        }
        String composedMessage = MessageFormat.format(baseMessage, message.toString());
        return RunnableOverwriteQuestion.showQuestion((String)Messages.ExportedAdapterHandler_overlappingTitle, (String)composedMessage);
    }
}

