/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.graphics.ImageData;

public class ExportedCompositeElementsHandler
implements IExportedResourceHandler {
    private static final String INDEX_FILE_NAME = "index.properties";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;
    private static final String EXPORTED_FOLDER_NAME = "compositeElements";

    @Override
    public String getResourceNameExport() {
        int elementsNumber = CompositeElementManager.INSTANCE.getAvailableElements().size();
        return "Composite Elements (" + elementsNumber + ")";
    }

    @Override
    public String getResourceNameImport(File exportedContainer) {
        return "Composite Elements (" + this.getRestorableResources(exportedContainer).size() + ")";
    }

    @Override
    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            for (MCompositeElement element : CompositeElementManager.INSTANCE.getAvailableElements()) {
                BaseResource resource = new BaseResource(element.getName());
                resource.setData(element);
                this.cachedExportableResources.add(resource);
            }
        }
        return this.cachedExportableResources;
    }

    @Override
    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                File exportedFolder = new File(exportedContainer, EXPORTED_FOLDER_NAME);
                File indexFile = new File(exportedFolder, INDEX_FILE_NAME);
                if (indexFile.exists()) {
                    FileInputStream is = null;
                    try {
                        try {
                            is = new FileInputStream(indexFile);
                            Properties loadedProperties = new Properties();
                            loadedProperties.load(is);
                            for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
                                BaseResource resource = new BaseResource(entry.getKey().toString());
                                resource.setData(entry.getKey());
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError(ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                        throw throwable;
                    }
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    @Override
    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block8: {
            HashSet<MCompositeElement> resourcesToExportSet = new HashSet<MCompositeElement>();
            for (IResourceDefinition definition : resourcesToExport) {
                resourcesToExportSet.add((MCompositeElement)definition.getData());
            }
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            tempDir.deleteOnExit();
            destDir = new File(tempDir, EXPORTED_FOLDER_NAME);
            if (destDir.exists()) {
                net.sf.jasperreports.eclipse.util.FileUtils.recursiveDelete((File)destDir);
            }
            destDir.mkdirs();
            ArrayList<MCompositeElement> elementsToExport = new ArrayList<MCompositeElement>();
            Properties props = new Properties();
            for (MCompositeElement element : CompositeElementManager.INSTANCE.getAvailableElements()) {
                if (!resourcesToExportSet.contains(element)) continue;
                elementsToExport.add(element);
                props.put(element.getName(), element.getName());
            }
            CompositeElementManager.INSTANCE.exportCompositeElement(elementsToExport, destDir);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(destDir, INDEX_FILE_NAME));
                    props.store(out, "Exported Elements Index");
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                throw throwable;
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    @Override
    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        File elementsFolder = new File(exportedContainer, EXPORTED_FOLDER_NAME);
        if (elementsFolder.exists()) {
            HashSet<String> filesToImport = new HashSet<String>();
            for (IResourceDefinition resourceToImport : resourcesToImport) {
                filesToImport.add(resourceToImport.getData().toString());
            }
            List<MCompositeElement> elements = CompositeElementManager.INSTANCE.loadCompositeElements(elementsFolder);
            HashMap<String, MCompositeElement> existingElements = new HashMap<String, MCompositeElement>();
            for (MCompositeElement storedElement : CompositeElementManager.INSTANCE.getAvailableElements()) {
                existingElements.put(storedElement.getName(), storedElement);
            }
            ArrayList<String> duplicatedElementsName = new ArrayList<String>();
            for (MCompositeElement element : elements) {
                if (!existingElements.containsKey(element.getName())) continue;
                duplicatedElementsName.add(element.getName());
            }
            RunnableOverwriteQuestion.RESPONSE_TYPE response = RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH;
            if (duplicatedElementsName.size() > 0) {
                response = this.askOverwrite(duplicatedElementsName);
            }
            for (MCompositeElement element : elements) {
                String name = element.getName();
                if (!filesToImport.contains(element.getName())) continue;
                if (existingElements.containsKey(name)) {
                    if (response == RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH) {
                        String newName = this.getName(existingElements, element.getName());
                        MCompositeElement renamedElement = new MCompositeElement(newName, element.getDescription(), element.getGroupId(), element.getPath(), element.getIconPathSmall(), element.getIconPathBig());
                        this.addCompositeElement(renamedElement);
                        continue;
                    }
                    if (response != RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE) continue;
                    MCompositeElement oldElement = existingElements.get(element.getName());
                    CompositeElementManager.INSTANCE.deleteCompositeElement(oldElement);
                    this.addCompositeElement(element);
                    continue;
                }
                this.addCompositeElement(element);
            }
        }
    }

    private void addCompositeElement(MCompositeElement element) {
        block7: {
            ImageData imageSmall = null;
            if (element.getIconSmall() != null) {
                imageSmall = element.getIconSmall().getImageData();
            }
            ImageData imageBig = null;
            if (element.getIconBig() != null) {
                imageBig = element.getIconBig().getImageData();
            }
            ByteArrayInputStream in = null;
            JasperDesign result = null;
            try {
                try {
                    File componentFile = new File(element.getPath());
                    File resourceFolder = element.getResourceFolder();
                    in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)componentFile));
                    JasperReportsConfiguration jConfig = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), null);
                    result = new JRXmlLoader((JasperReportsContext)jConfig, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)jConfig)).loadXML((InputStream)in);
                    this.checkResources(result.getTitle().getChildren(), resourceFolder, element.getName());
                    jConfig.setJasperDesign(result);
                    CompositeElementManager.INSTANCE.addCompositeElement(element.getName(), element.getDescription(), element.getGroupId(), imageSmall, imageBig, result, resourceFolder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                throw throwable;
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
        }
    }

    private void checkResources(List<JRChild> children, File currentResourcesLocation, String elementNewName) {
        for (JRChild newElement : children) {
            String textualExp;
            File oldResource;
            JRExpression exp;
            if (newElement instanceof JRDesignImage && (exp = ((JRDesignImage)newElement).getExpression()) != null && new File(currentResourcesLocation, (oldResource = new File(textualExp = JRExpressionUtil.getSimpleExpressionText((JRExpression)exp))).getName()).exists()) {
                File newResourceFolder = CompositeElementManager.INSTANCE.getResourceDir(elementNewName);
                File newResource = new File(newResourceFolder, oldResource.getName());
                ((JRDesignImage)newElement).setExpression((JRExpression)new JRDesignExpression("\"" + newResource.getAbsolutePath() + "\""));
            }
            if (!(newElement instanceof JRElementGroup)) continue;
            this.checkResources(((JRElementGroup)newElement).getChildren(), currentResourcesLocation, elementNewName);
        }
    }

    private RunnableOverwriteQuestion.RESPONSE_TYPE askOverwrite(List<String> elementsName) {
        String baseMessage = Messages.ExportedCompositeElementsHandler_overlappingMessage;
        StringBuilder message = new StringBuilder("\n");
        int index = 1;
        for (String elementName : elementsName) {
            message.append(elementName);
            message.append(index == elementsName.size() ? ".\n" : ",\n");
            ++index;
        }
        String composedMessage = MessageFormat.format(baseMessage, message.toString());
        return RunnableOverwriteQuestion.showQuestion((String)Messages.ExportedCompositeElementsHandler_overlappingTitle, (String)composedMessage);
    }

    private String getName(HashMap<String, MCompositeElement> existingElements, String baseName) {
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (existingElements.containsKey(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }
}

