/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter.wizard;

import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.action.exporter.wizard.ShowImportableWizardPage;
import com.jaspersoft.studio.editor.action.exporter.wizard.SourcePage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ConfigurationImporterWizard
extends Wizard
implements IImportWizard {
    private SourcePage page0;
    private ShowImportableWizardPage page1;

    public void addPages() {
        super.addPages();
        this.page0 = new SourcePage();
        this.addPage((IWizardPage)this.page0);
        this.page1 = new ShowImportableWizardPage();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean canFinish() {
        return this.page0.isPageComplete() && this.page1.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected String getSelectedFile() {
        return this.page0.getDestinationPath();
    }

    public boolean performFinish() {
        try {
            this.setNeedsProgressMonitor(true);
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map<IExportedResourceHandler, List<IResourceDefinition>> selectedResources = ConfigurationImporterWizard.this.page1.getSelectedResources();
                    monitor.beginTask("Restoring Resources", selectedResources.keySet().size());
                    final File importContainerLocation = new File(ConfigurationImporterWizard.this.getSelectedFile());
                    for (Map.Entry<IExportedResourceHandler, List<IResourceDefinition>> selectedEntry : selectedResources.entrySet()) {
                        final IExportedResourceHandler currentExporter = selectedEntry.getKey();
                        final List<IResourceDefinition> exporterSelection = selectedEntry.getValue();
                        UIUtils.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                currentExporter.restoreContentFolder(importContainerLocation, exporterSelection);
                            }
                        });
                        monitor.worked(1);
                    }
                    FileUtils.recursiveDelete((File)importContainerLocation);
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

