/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter.wizard;

import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.editor.action.exporter.wizard.CheckboxTreeAndListGroup;
import com.jaspersoft.studio.editor.action.exporter.wizard.ConfigurationImporterWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShowImportableWizardPage
extends JSSWizardPage {
    private CheckboxTreeAndListGroup resourceSelectionList;
    private ITreeContentProvider treeContentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return element instanceof List;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }
    };
    private IStructuredContentProvider listContentProvider = new IStructuredContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IExportedResourceHandler) {
                ConfigurationImporterWizard parentWizard = (ConfigurationImporterWizard)ShowImportableWizardPage.this.getWizard();
                File importLocation = new File(parentWizard.getSelectedFile());
                return ((IExportedResourceHandler)inputElement).getRestorableResources(importLocation).toArray();
            }
            return new Object[0];
        }
    };
    private ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof IExportedResourceHandler) {
                ConfigurationImporterWizard parentWizard = (ConfigurationImporterWizard)ShowImportableWizardPage.this.getWizard();
                File importLocation = new File(parentWizard.getSelectedFile());
                return ((IExportedResourceHandler)element).getResourceNameImport(importLocation);
            }
            if (element instanceof IResourceDefinition) {
                return ((IResourceDefinition)element).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    protected ShowImportableWizardPage() {
        super("showImportablePage");
        this.setTitle(Messages.SourcePage_pageDescription);
        this.setDescription(Messages.ShowImportableWizardPage_pageDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.resourceSelectionList = new CheckboxTreeAndListGroup(container, null, this.treeContentProvider, this.labelProvider, this.listContentProvider, this.labelProvider, 0, 500, 400);
        this.resourceSelectionList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ShowImportableWizardPage.this.validate();
            }
        });
        this.setControl((Control)container);
        this.validate();
    }

    protected List<IExportedResourceHandler> getRootObject() {
        ArrayList<IExportedResourceHandler> result = new ArrayList<IExportedResourceHandler>();
        ConfigurationImporterWizard parentWizard = (ConfigurationImporterWizard)this.getWizard();
        File importLocation = new File(parentWizard.getSelectedFile());
        for (IExportedResourceHandler definition : ExtensionManager.getContributedExporters()) {
            if (definition.getRestorableResources(importLocation).size() <= 0) continue;
            result.add(definition);
        }
        return result;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resourceSelectionList.setRoot(this.getRootObject());
        }
        super.setVisible(visible);
    }

    @Override
    protected String getContextName() {
        return null;
    }

    public Map<IExportedResourceHandler, List<IResourceDefinition>> getSelectedResources() {
        HashMap<IExportedResourceHandler, List<IResourceDefinition>> result = new HashMap<IExportedResourceHandler, List<IResourceDefinition>>();
        for (Object selectedTreeItem : this.resourceSelectionList.getAllCheckedTreeItems()) {
            IExportedResourceHandler importedType = (IExportedResourceHandler)selectedTreeItem;
            List<Object> selectedListItems = this.resourceSelectionList.getCheckedListEntryForTreeItem(importedType);
            if (selectedListItems == null || selectedListItems.isEmpty()) continue;
            ArrayList<IResourceDefinition> selectedResources = new ArrayList<IResourceDefinition>();
            for (Object selectedItem : selectedListItems) {
                selectedResources.add((IResourceDefinition)selectedItem);
            }
            result.put(importedType, selectedResources);
        }
        return result;
    }

    protected void validate() {
        this.setPageComplete(!this.getSelectedResources().keySet().isEmpty());
    }
}

