/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.json;

import com.jaspersoft.studio.editor.action.json.JSONAction;
import com.jaspersoft.studio.editor.gef.decorator.json.SchemaDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class JSONSchemaAction
extends JSONAction {
    private String path;

    public JSONSchemaAction(IWorkbenchPart part) {
        super(part, "net.sf.jasperreports.export.json.schema", Messages.JSONSchemaAction_0);
    }

    @Override
    public void run() {
        MReport element = this.getSelectedElement();
        if (element == null) {
            return;
        }
        SchemaDialog dialog = new SchemaDialog(UIUtils.getShell(), element);
        if (dialog.open() == 0) {
            this.path = dialog.getName();
            this.execute(this.createCommand());
        }
    }

    private MReport getSelectedElement() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MReport.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return null;
        }
        return (MReport)textElements.get(0);
    }

    @Override
    public boolean isChecked() {
        MReport model = this.getSelectedElement();
        if (model == null) {
            return false;
        }
        JRPropertiesMap colDataMap = model.getValue().getPropertiesMap();
        return colDataMap.containsProperty("net.sf.jasperreports.export.json.schema");
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.editor.getSelectionCache().getSelectionModelForType(MReport.class).isEmpty();
    }

    @Override
    protected Command createCommand() {
        MReport n = this.getSelectedElement();
        if (n == null) {
            return null;
        }
        JRPropertiesMap map = (JRPropertiesMap)n.getPropertyValue("PROPERTY_MAP");
        if (map == null) {
            map = new JRPropertiesMap();
        }
        if (this.path == null) {
            map.removeProperty("net.sf.jasperreports.export.json.schema");
        } else {
            map.setProperty("net.sf.jasperreports.export.json.schema", this.path);
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(n);
        cmd.setPropertyId("PROPERTY_MAP");
        cmd.setPropertyValue(map);
        cmd.setDebugLabel(this.getText());
        return cmd;
    }
}

