/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.pdf;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.pdf.Position;
import com.jaspersoft.studio.editor.action.pdf.PropertiesList;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public abstract class PdfActionAbstract
extends CustomSelectionAction {
    public final String ID_Full;
    public final String ID_Start;
    public final String ID_End;
    public final String ID_None;
    protected Position action_position;

    protected abstract String getPropertyName();

    public PdfActionAbstract(IWorkbenchPart part, Position action_position, String ID_Full, String ID_Start, String ID_End, String ID_None) {
        super(part, 2);
        this.action_position = action_position;
        this.ID_Full = ID_Full;
        this.ID_Start = ID_Start;
        this.ID_End = ID_End;
        this.ID_None = ID_None;
        PropertiesList.addItem(this.getPropertyName());
        this.initUI();
    }

    public boolean isChecked() {
        this.ischecked = true;
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            this.ischecked = false;
        } else {
            String attributeId = this.getPropertyName();
            String value = this.getPropertyValue();
            for (Object element : graphicalElements) {
                MGraphicElement model = (MGraphicElement)element;
                JRPropertiesMap v = model.getPropertiesMap();
                if (v == null) {
                    this.ischecked = false;
                    break;
                }
                String oldValue = v.getProperty(attributeId);
                if (oldValue != null && oldValue.equals(value)) continue;
                this.ischecked = false;
                break;
            }
        }
        return this.ischecked;
    }

    protected void initUI() {
        switch (this.action_position) {
            case Full: {
                this.setId(this.ID_Full);
                this.setText(Messages.PdfAction_Full);
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case Start: {
                this.setId(this.ID_Start);
                this.setText(Messages.PdfAction_Start);
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case End: {
                this.setId(this.ID_End);
                this.setText(Messages.PdfAction_End);
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case None: {
                this.setId(this.ID_None);
                this.setText(Messages.PdfAction_None);
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
            }
        }
    }

    protected String getPropertyValue() {
        String value = "";
        switch (this.action_position) {
            case Full: {
                value = "full";
                break;
            }
            case Start: {
                value = "start";
                break;
            }
            case End: {
                value = "end";
                break;
            }
            case None: {
                value = null;
            }
        }
        return value;
    }

    public Command createCommand(MGraphicElement model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        String name = this.getPropertyName();
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        String oldValue = null;
        if (v == null) {
            v = new JRPropertiesMap();
        } else {
            oldValue = v.getProperty(name);
            v.removeProperty(name);
        }
        String value = this.getPropertyValue();
        if (value != null && !value.equals(oldValue)) {
            v.setProperty(name, value);
        }
        cmd.setPropertyValue(v);
        return cmd;
    }

    @Override
    protected Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(this.getText(), null);
        for (Object element : graphicalElements) {
            MGraphicElement grModel = (MGraphicElement)element;
            command.setReferenceNodeIfNull(grModel);
            command.add(this.createCommand(grModel));
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }
}

