/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.pdf;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.pdf.Heading;
import com.jaspersoft.studio.editor.action.pdf.PropertiesList;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class PdfActionHeading
extends CustomSelectionAction {
    public static final String EXPORT_PDF_ACCESSIBILITY_TAG = "net.sf.jasperreports.export.accessibility.tag";
    public static final String ID_TABLE_HEADING_H1 = "PdfAction_Table_Heading_H1";
    public static final String ID_TABLE_HEADING_H2 = "PdfAction_Table_Heading_H2";
    public static final String ID_TABLE_HEADING_H3 = "PdfAction_Table_Heading_H3";
    public static final String ID_TABLE_HEADING_H4 = "PdfAction_Table_Heading_H4";
    public static final String ID_TABLE_HEADING_H5 = "PdfAction_Table_Heading_H5";
    public static final String ID_TABLE_HEADING_H6 = "PdfAction_Table_Heading_H6";
    private Heading actionHeading;

    public PdfActionHeading(IWorkbenchPart part, Heading actionHeading) {
        super(part, 2);
        this.actionHeading = actionHeading;
        PropertiesList.addItem(EXPORT_PDF_ACCESSIBILITY_TAG);
        this.initUI();
    }

    protected String getPropertyName() {
        return EXPORT_PDF_ACCESSIBILITY_TAG;
    }

    public boolean isChecked() {
        this.ischecked = true;
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            this.ischecked = false;
        } else {
            String attributeId = this.getPropertyName();
            String value = this.actionHeading.getTextValue();
            for (Object element : graphicalElements) {
                MGraphicElement model = (MGraphicElement)element;
                JRPropertiesMap v = model.getPropertiesMap();
                if (v == null) {
                    this.ischecked = false;
                    break;
                }
                String oldValue = v.getProperty(attributeId);
                if (oldValue != null && oldValue.equals(value)) continue;
                this.ischecked = false;
                break;
            }
        }
        return this.ischecked;
    }

    protected void initUI() {
        switch (this.actionHeading) {
            case H1: {
                this.setId(ID_TABLE_HEADING_H1);
                this.setText(Heading.H1.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case H2: {
                this.setId(ID_TABLE_HEADING_H2);
                this.setText(Heading.H2.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case H3: {
                this.setId(ID_TABLE_HEADING_H3);
                this.setText(Heading.H3.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case H4: {
                this.setId(ID_TABLE_HEADING_H4);
                this.setText(Heading.H4.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case H5: {
                this.setId(ID_TABLE_HEADING_H5);
                this.setText(Heading.H5.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
                break;
            }
            case H6: {
                this.setId(ID_TABLE_HEADING_H6);
                this.setText(Heading.H6.getName());
                this.setToolTipText(null);
                this.setImageDescriptor(null);
                this.setDisabledImageDescriptor(null);
            }
        }
    }

    public Command createCommand(MGraphicElement model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        String name = this.getPropertyName();
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        String oldValue = null;
        if (v == null) {
            v = new JRPropertiesMap();
        } else {
            oldValue = v.getProperty(name);
            v.removeProperty(name);
        }
        String value = this.actionHeading.getTextValue();
        if (value != null && !value.equals(oldValue)) {
            v.setProperty(name, value);
        }
        cmd.setPropertyValue(v);
        return cmd;
    }

    @Override
    protected Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(this.getText(), null);
        for (Object element : graphicalElements) {
            MGraphicElement grModel = (MGraphicElement)element;
            command.setReferenceNodeIfNull(grModel);
            command.add(this.createCommand(grModel));
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }
}

