/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.pdf;

import com.jaspersoft.studio.editor.action.pdf.APdfAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.widget.AWidget;
import com.jaspersoft.studio.property.dataset.fields.table.widget.WJRProperty;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.export.type.PdfFieldTypeEnum;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.apache.commons.lang.WordUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PdfFieldAction
extends APdfAction {
    public static final String ID_PDF_FIELD_ACTION = "ID_PDF_FIELD_ACTION";
    private static final Map<String, PropertyMetadata> props = new HashMap<String, PropertyMetadata>();
    private Map<String, String> values = new HashMap<String, String>();
    private static Set<String> p = new HashSet<String>();
    private FieldDialog dialog;

    static {
        p.add("net.sf.jasperreports.export.pdf.field.border.style");
        p.add("net.sf.jasperreports.export.pdf.field.check.type");
        p.add("net.sf.jasperreports.export.pdf.field.checked");
        p.add("net.sf.jasperreports.export.pdf.field.choice.separators");
        p.add("net.sf.jasperreports.export.pdf.field.choices");
        p.add("net.sf.jasperreports.export.pdf.field.combo.edit");
        p.add("net.sf.jasperreports.export.pdf.field.name");
        p.add("net.sf.jasperreports.export.pdf.field.read.only");
        p.add("net.sf.jasperreports.export.pdf.field.text.multiline");
        p.add("net.sf.jasperreports.export.pdf.field.type");
        p.add("net.sf.jasperreports.export.pdf.field.value");
    }

    public PdfFieldAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected void initUI() {
        this.setId(ID_PDF_FIELD_ACTION);
        this.setText(Messages.PdfFieldAction_1);
        this.setToolTipText(Messages.PdfFieldAction_2);
        this.setImageDescriptor(null);
        this.setDisabledImageDescriptor(null);
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        return graphicalElements.size() == 1;
    }

    @Override
    protected Set<String> getPropertyNames() {
        return p;
    }

    @Override
    protected Object getPropertyValue(String name) {
        if (this.dialog != null && this.dialog.getValue() != null) {
            String v;
            JRDesignElement dv = this.dialog.getValue();
            if (dv.getPropertiesMap() != null && (v = dv.getPropertiesMap().getProperty(name)) != null) {
                return v;
            }
            if (dv.getPropertyExpressionsList() != null) {
                for (JRPropertyExpression pe : dv.getPropertyExpressionsList()) {
                    if (!pe.getName().equals(name)) continue;
                    return pe;
                }
            }
        }
        return null;
    }

    @Override
    public void run() {
        this.dialog = new FieldDialog(UIUtils.getShell());
        if (this.dialog.open() == 0) {
            super.run();
        }
    }

    private class FieldDialog
    extends ATitledDialog {
        private MGraphicElement m;
        private JRDesignElement eClone;
        private JasperReportsConfiguration jConf;
        private Map<String, WJRProperty> controls;

        protected FieldDialog(Shell parentShell) {
            super(parentShell, false);
            this.controls = new HashMap<String, WJRProperty>();
            this.setTitle(PdfFieldAction.this.getText());
            this.setDescription(PdfFieldAction.this.getToolTipText());
            List<Object> graphicalElements = PdfFieldAction.this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
            this.m = (MGraphicElement)graphicalElements.get(0);
            this.eClone = (JRDesignElement)this.m.getValue().clone();
            this.jConf = this.m.getJasperConfiguration();
            if (props.isEmpty()) {
                List<PropertyMetadata> pms = HintsPropertiesList.getPropertiesMetadata((Object)this.m.getValue(), this.m.getJasperConfiguration());
                pms.stream().filter(pm -> PdfFieldAction.this.getPropertyNames().contains(pm.getName())).forEach(pm -> {
                    PropertyMetadata propertyMetadata = props.put(pm.getName(), (PropertyMetadata)pm);
                });
            }
        }

        public JRDesignElement getValue() {
            return this.eClone;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite cmp = new Composite(area, 0);
            cmp.setLayout((Layout)new GridLayout(2, false));
            cmp.setLayoutData((Object)new GridData(1808));
            TColumn tc = TColumnFactory.getTColumn(props.get("net.sf.jasperreports.export.pdf.field.name"));
            tc.setLabel(Messages.PdfFieldAction_3);
            Control lbl = ((WJRProperty)TColumnFactory.addWidget(tc, cmp, this.eClone, this.jConf)).getLabel();
            if (lbl != null) {
                GridData gd = new GridData();
                gd.widthHint = 150;
                lbl.setLayoutData((Object)gd);
            }
            tc = TColumnFactory.getTColumn(props.get("net.sf.jasperreports.export.pdf.field.border.style"));
            tc.setLabel(Messages.PdfFieldAction_4);
            TColumnFactory.addWidget(tc, cmp, this.eClone, this.jConf);
            tc = TColumnFactory.getTColumn(props.get("net.sf.jasperreports.export.pdf.field.read.only"));
            tc.setLabel(Messages.PdfFieldAction_5);
            TColumnFactory.addWidget(tc, cmp, this.eClone, this.jConf);
            tc = TColumnFactory.getTColumn(props.get("net.sf.jasperreports.export.pdf.field.type"));
            if (!(this.m instanceof MTextElement)) {
                HashSet<PdfFieldTypeEnum> hev = new HashSet<PdfFieldTypeEnum>();
                hev.add(PdfFieldTypeEnum.TEXT);
                tc.setHideEnumValues(hev);
            }
            tc.setLabel(Messages.PdfFieldAction_6);
            TColumnFactory.addWidget(tc, cmp, this.eClone, this.jConf);
            JRPropertiesMap v = this.eClone.getPropertiesMap();
            v.getEventSupport().addPropertyChangeListener("net.sf.jasperreports.export.pdf.field.type", evt -> {
                String t = this.getType(v);
                if (!(this.m instanceof MTextElement) && PdfFieldTypeEnum.TEXT.getName().equalsIgnoreCase(t)) {
                    UIUtils.showInformation((String)"You can use Text type only with TextField and StaticText");
                    return;
                }
                this.changeType(t, cmp);
                cmp.update();
                cmp.layout(true);
                UIUtils.getDisplay().asyncExec(() -> UIUtils.relayoutDialogHeight((Shell)this.getShell(), (int)this.defheight));
            });
            this.changeType(this.getType(v), cmp);
            return area;
        }

        private String getType(JRPropertiesMap v) {
            String type = v.getProperty("net.sf.jasperreports.export.pdf.field.type");
            if (type != null) {
                PdfFieldAction.this.values.put("net.sf.jasperreports.export.pdf.field.type", type);
            }
            return type;
        }

        private void changeType(String type, Composite cmp) {
            for (WJRProperty c : this.controls.values()) {
                c.dispose();
            }
            this.controls.clear();
            JRPropertiesMap pm = this.eClone.getPropertiesMap();
            if (type != null) {
                switch (PdfFieldTypeEnum.getByName((String)WordUtils.capitalize((String)type.toLowerCase()))) {
                    case TEXT: {
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.choice.separators");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.choices");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.checked");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.check.type");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.choice.separators");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.choices");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.checked");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.check.type");
                        this.buildText(cmp);
                        break;
                    }
                    case COMBO: 
                    case LIST: {
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.checked");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.check.type");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.text.multiline");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.checked");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.check.type");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.text.multiline");
                        this.buildList(cmp);
                        break;
                    }
                    case CHECK: 
                    case RADIO: {
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.choice.separators");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.choices");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.text.multiline");
                        pm.removeProperty("net.sf.jasperreports.export.pdf.field.value");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.choice.separators");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.choices");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.text.multiline");
                        this.eClone.removePropertyExpression("net.sf.jasperreports.export.pdf.field.value");
                        this.buildCheck(cmp);
                        break;
                    }
                    default: {
                        UIUtils.showInformation((String)Messages.PdfFieldAction_7);
                    }
                }
            }
        }

        private void buildList(Composite cmp) {
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.choices", Messages.PdfFieldAction_8);
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.value", "Selected Choice Value");
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.choice.separators", Messages.PdfFieldAction_9);
        }

        private void buildCheck(Composite cmp) {
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.check.type", Messages.PdfFieldAction_10);
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.checked", Messages.PdfFieldAction_11);
        }

        private void buildText(Composite cmp) {
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.value", "Selected Choice Value");
            this.buildProp(cmp, "net.sf.jasperreports.export.pdf.field.text.multiline", Messages.PdfFieldAction_12);
        }

        private void buildProp(Composite cmp, String p, String label) {
            AWidget w;
            TColumn tc = TColumnFactory.getTColumn(props.get(p));
            if (label != null) {
                tc.setLabel(label);
            }
            if ((w = TColumnFactory.addWidget(tc, cmp, this.eClone, this.jConf)) instanceof WJRProperty) {
                this.controls.put(p, (WJRProperty)w);
            }
        }
    }
}

