/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.reportsplitting;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import java.util.List;
import java.util.function.Predicate;
import net.sf.jasperreports.engine.JRExpression;

public class ReportSplittingPropertyEditor
implements IPropertyEditor {
    private PropertyExpressionsDTO pExpressionsDTO;
    private JasperReportsConfiguration jconfig;

    public ReportSplittingPropertyEditor(PropertyExpressionsDTO pExpressionsDTO, JasperReportsConfiguration jconfig) {
        this.pExpressionsDTO = pExpressionsDTO;
        this.jconfig = jconfig;
    }

    public PropertyExpressionDTO getProperty(String propertyName) {
        for (PropertyExpressionDTO pExpr : this.pExpressionsDTO.getProperties()) {
            if (!pExpr.getName().equals(propertyName)) continue;
            return pExpr;
        }
        return null;
    }

    public void addProperty(PropertyExpressionDTO newProperty) {
        this.pExpressionsDTO.getProperties().add(newProperty);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        PropertyExpressionDTO property = this.getProperty(propertyName);
        if (property != null && !property.isExpression()) {
            return property.getValue();
        }
        return null;
    }

    @Override
    public JRExpression getPropertyValueExpression(String propertyName) {
        PropertyExpressionDTO property = this.getProperty(propertyName);
        if (property != null && property.isExpression()) {
            return property.getValueAsExpression();
        }
        return null;
    }

    public List<PropertyExpressionDTO> getAllProperties() {
        return this.pExpressionsDTO.getProperties();
    }

    public PropertyExpressionsDTO getPropertiesDTO() {
        return this.pExpressionsDTO;
    }

    @Override
    public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
        this.removeProperty(propertyName);
        if (value != null || valueExpression != null) {
            this.pExpressionsDTO.addProperty(propertyName, this.getValueForPropertyCreation(value, valueExpression), this.shouldBeExpression(value, valueExpression), false);
        }
    }

    private String getValueForPropertyCreation(String value, JRExpression valueExpression) {
        if (this.shouldBeExpression(value, valueExpression)) {
            return valueExpression.getText();
        }
        return value;
    }

    private boolean shouldBeExpression(String value, JRExpression valueExpression) {
        if (value == null && valueExpression != null) {
            return true;
        }
        if (value != null && valueExpression == null) {
            return false;
        }
        throw new RuntimeException(Messages.ReportSplittingPropertyEditor_RuntimeExceptionMsg);
    }

    @Override
    public void removeProperty(String propertyName) {
        PropertyExpressionDTO existingProperty = this.getProperty(propertyName);
        if (existingProperty != null) {
            this.pExpressionsDTO.getProperties().remove(existingProperty);
        }
    }

    public void removeAllSplittingProperties() {
        Predicate<PropertyExpressionDTO> isSplittingProperty = item -> item.getName().startsWith("net.sf.jasperreports.print.part.");
        this.pExpressionsDTO.getProperties().removeIf(isSplittingProperty);
    }
}

