/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.size;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.gef.commands.ResizeCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class Size2BorderAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID_SIZE_WIDTH = "band_WIDTH";
    public static final String ID_SIZE_HEIGHT = "band_HEIGHT";
    public static final String ID_SIZE_BOTH = "band_BOTH";
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int BOTH = 2;
    private int alignment;

    public Size2BorderAction(IWorkbenchPart part, int alignment) {
        super(part);
        this.alignment = alignment;
        this.initUI();
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionModelPartForType(MGraphicElement.class);
        if ((editparts = ToolUtilitiesCompatibility.getSelectionWithoutDependants(editparts)).isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            if (editpart.getModel() instanceof MGraphicElement) {
                command.add(new ResizeCommand(this.alignment, editpart));
                command.setReferenceNodeIfNull(editpart.getModel());
            }
            ++i;
        }
        return command;
    }

    protected void initUI() {
        switch (this.alignment) {
            case 0: {
                this.setId(ID_SIZE_WIDTH);
                this.setText(Messages.Size2BorderAction_fit_width);
                this.setToolTipText(Messages.Size2BorderAction_fit_width_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control_width.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control_width.gif"));
                break;
            }
            case 1: {
                this.setId(ID_SIZE_HEIGHT);
                this.setText(Messages.Size2BorderAction_fit_height);
                this.setToolTipText(Messages.Size2BorderAction_fit_height_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control_height.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control_height.gif"));
                break;
            }
            case 2: {
                this.setId(ID_SIZE_BOTH);
                this.setText(Messages.Size2BorderAction_fit_both);
                this.setToolTipText(Messages.Size2BorderAction_fit_both_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/size_to_control.gif"));
            }
        }
    }
}

