/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.gef.parts.text.StaticTextFigureEditPart;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertStaticIntoText
extends ACachedSelectionAction {
    public static final String ID = "ConvertStaticIntoText";

    public ConvertStaticIntoText(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.ConvertStaticIntoText_actionName);
        this.setToolTipText(Messages.ConvertStaticIntoText_actionTooltip);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/convert_to_field.png"));
    }

    private boolean isValidExpression(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return true;
        }
        if (value.startsWith("$P{") && value.endsWith("}")) {
            return true;
        }
        if (value.startsWith("$V{") && value.endsWith("}")) {
            return true;
        }
        if (value.startsWith("$R{") && value.endsWith("}")) {
            return true;
        }
        return value.startsWith("$F{") && value.endsWith("}");
    }

    private void cloneBox(JRLineBox fieldBox, JRLineBox staticBox) {
        if (fieldBox == null || staticBox == null) {
            return;
        }
        fieldBox.setBottomPadding(staticBox.getOwnBottomPadding());
        fieldBox.setLeftPadding(staticBox.getOwnLeftPadding());
        fieldBox.setPadding(staticBox.getOwnPadding());
        fieldBox.setRightPadding(staticBox.getOwnRightPadding());
        fieldBox.setTopPadding(staticBox.getOwnTopPadding());
        fieldBox.copyTopPen(staticBox.getTopPen());
        fieldBox.copyBottomPen(staticBox.getBottomPen());
        fieldBox.copyLeftPen(staticBox.getLeftPen());
        fieldBox.copyRightPen(staticBox.getRightPen());
        fieldBox.copyPen(staticBox.getPen());
    }

    private void cloneParagraph(JRParagraph fieldBox, JRParagraph staticBox) {
        if (fieldBox == null || staticBox == null) {
            return;
        }
        fieldBox.setFirstLineIndent(staticBox.getOwnFirstLineIndent());
        fieldBox.setLeftIndent(staticBox.getOwnLeftIndent());
        fieldBox.setLineSpacing(staticBox.getOwnLineSpacing());
        fieldBox.setLineSpacingSize(staticBox.getOwnLineSpacingSize());
        fieldBox.setRightIndent(staticBox.getOwnRightIndent());
        fieldBox.setSpacingAfter(staticBox.getOwnSpacingAfter());
        fieldBox.setSpacingBefore(staticBox.getOwnSpacingBefore());
        fieldBox.setTabStopWidth(staticBox.getOwnTabStopWidth());
    }

    private void cloneTextField(JRDesignTextField textObject, JRDesignStaticText labelObject) {
        String staticTextValue = labelObject.getText();
        if (staticTextValue.isEmpty()) {
            staticTextValue = "\"\"";
        } else if (!this.isValidExpression(staticTextValue)) {
            if (!staticTextValue.startsWith("\"")) {
                staticTextValue = "\"".concat(staticTextValue);
            }
            if (!staticTextValue.endsWith("\"")) {
                staticTextValue = staticTextValue.concat("\"");
            }
        }
        textObject.setExpression(ExprUtil.setValues(textObject.getExpression(), staticTextValue));
        textObject.setHeight(labelObject.getHeight());
        textObject.setWidth(labelObject.getWidth());
        textObject.setX(labelObject.getX());
        textObject.setY(labelObject.getY());
        textObject.setFontName(labelObject.getOwnFontName());
        textObject.setFontSize(labelObject.getOwnFontsize());
        textObject.setBackcolor(labelObject.getOwnBackcolor());
        textObject.setForecolor(labelObject.getOwnForecolor());
        JRStyle originStyle = labelObject.getStyle();
        textObject.setStyle(originStyle);
        textObject.setStyleNameReference(labelObject.getStyleNameReference());
        textObject.setBold(labelObject.isOwnBold());
        textObject.setItalic(labelObject.isOwnItalic());
        textObject.setUnderline(labelObject.isOwnUnderline());
        textObject.setStrikeThrough(labelObject.isOwnStrikeThrough());
        textObject.setHorizontalTextAlign(labelObject.getOwnHorizontalTextAlign());
        textObject.setVerticalTextAlign(labelObject.getOwnVerticalTextAlign());
        textObject.setMode(labelObject.getOwnModeValue());
        textObject.setRotation(labelObject.getOwnRotationValue());
        textObject.setStretchType(labelObject.getStretchTypeValue());
        textObject.setKey(labelObject.getKey());
        textObject.setMarkup(labelObject.getOwnMarkup());
        textObject.setPdfEmbedded(labelObject.isOwnPdfEmbedded());
        textObject.setPdfEncoding(labelObject.getOwnPdfEncoding());
        textObject.setPdfFontName(labelObject.getOwnPdfFontName());
        textObject.setPositionType(labelObject.getPositionTypeValue());
        textObject.setPrintInFirstWholeBand(labelObject.isPrintInFirstWholeBand());
        textObject.setPrintRepeatedValues(labelObject.isPrintRepeatedValues());
        textObject.setPrintWhenDetailOverflows(labelObject.isPrintWhenDetailOverflows());
        this.cloneBox(textObject.getLineBox(), labelObject.getLineBox());
        this.cloneParagraph(textObject.getParagraph(), labelObject.getParagraph());
        JRExpression originExpression = labelObject.getPrintWhenExpression();
        textObject.setPrintWhenExpression(originExpression != null ? (JRExpression)originExpression.clone() : null);
        JRGroup originGroup = labelObject.getPrintWhenGroupChanges();
        textObject.setPrintWhenGroupChanges(originGroup != null ? (JRGroup)originGroup.clone() : null);
        textObject.setRemoveLineWhenBlank(labelObject.isRemoveLineWhenBlank());
        String[] stringArray = labelObject.getPropertiesMap().getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            String propertyValue = labelObject.getPropertiesMap().getProperty(propertyName);
            textObject.getPropertiesMap().setProperty(propertyName, propertyValue);
            ++n2;
        }
        for (JRPropertyExpression propertyExpression : labelObject.getPropertyExpressionsList()) {
            textObject.addPropertyExpression((JRPropertyExpression)propertyExpression.clone());
        }
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionPartForType(StaticTextFigureEditPart.class);
        if (editparts.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        for (Object part : editparts) {
            StaticTextFigureEditPart editPart = (StaticTextFigureEditPart)part;
            MStaticText staticText = (MStaticText)editPart.getModel();
            command.setReferenceNodeIfNull(staticText);
            DeleteElementCommand deleteCommand = new DeleteElementCommand(staticText);
            LazyCreateTextFieldCommand createCommand = new LazyCreateTextFieldCommand(staticText);
            command.add(deleteCommand);
            command.add(createCommand);
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    private class LazyCreateTextFieldCommand
    extends Command {
        private CreateElementCommand cmd = null;
        private MStaticText elementToCopy;
        private int oldIndex;
        private ANode parent;

        public LazyCreateTextFieldCommand(MStaticText elementToCopy) {
            this.elementToCopy = elementToCopy;
            this.parent = elementToCopy.getParent();
            this.oldIndex = ModelUtils.getChildrenPosition(elementToCopy);
        }

        public void execute() {
            MTextField modelText = new MTextField();
            JRDesignStaticText labelObject = (JRDesignStaticText)this.elementToCopy.getValue();
            JRDesignTextField textObject = (JRDesignTextField)modelText.createJRElement(this.elementToCopy.getJasperDesign());
            ConvertStaticIntoText.this.cloneTextField(textObject, labelObject);
            modelText.setValue(textObject);
            Rectangle position = new Rectangle(labelObject.getX(), labelObject.getY(), labelObject.getWidth(), labelObject.getHeight());
            this.cmd = new CreateElementCommand(this.parent, (MGraphicElement)modelText, position, this.oldIndex);
            this.cmd.setJasperDesign(this.parent.getJasperDesign());
            this.cmd.execute();
        }

        public void undo() {
            this.cmd.undo();
            this.cmd = null;
        }

        public boolean canExecute() {
            return this.elementToCopy != null && this.parent != null;
        }

        public boolean canUndo() {
            return this.cmd != null;
        }
    }
}

