/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.text;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.gef.parts.text.TextFieldFigureEditPart;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertTextIntoStatic
extends ACachedSelectionAction {
    public static final String ID = "ConvertTextIntoStatic";

    public ConvertTextIntoStatic(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.ConvertTextIntoStatic_actionName);
        this.setToolTipText(Messages.ConvertTextIntoStatic_actionToolTip);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/convert_to_text.png"));
    }

    private void cloneBox(JRLineBox fieldBox, JRLineBox staticBox) {
        if (fieldBox == null || staticBox == null) {
            return;
        }
        fieldBox.setBottomPadding(staticBox.getOwnBottomPadding());
        fieldBox.setLeftPadding(staticBox.getOwnLeftPadding());
        fieldBox.setPadding(staticBox.getOwnPadding());
        fieldBox.setRightPadding(staticBox.getOwnRightPadding());
        fieldBox.setTopPadding(staticBox.getOwnTopPadding());
        fieldBox.copyTopPen(staticBox.getTopPen());
        fieldBox.copyBottomPen(staticBox.getBottomPen());
        fieldBox.copyLeftPen(staticBox.getLeftPen());
        fieldBox.copyRightPen(staticBox.getRightPen());
        fieldBox.copyPen(staticBox.getPen());
    }

    private void cloneParagraph(JRParagraph fieldBox, JRParagraph staticBox) {
        if (fieldBox == null || staticBox == null) {
            return;
        }
        fieldBox.setFirstLineIndent(staticBox.getOwnFirstLineIndent());
        fieldBox.setLeftIndent(staticBox.getOwnLeftIndent());
        fieldBox.setLineSpacing(staticBox.getOwnLineSpacing());
        fieldBox.setLineSpacingSize(staticBox.getOwnLineSpacingSize());
        fieldBox.setRightIndent(staticBox.getOwnRightIndent());
        fieldBox.setSpacingAfter(staticBox.getOwnSpacingAfter());
        fieldBox.setSpacingBefore(staticBox.getOwnSpacingBefore());
        fieldBox.setTabStopWidth(staticBox.getOwnTabStopWidth());
    }

    private void cloneTextField(JRDesignStaticText labelObject, JRDesignTextField textObject) {
        labelObject.setText(textObject.getExpression().getText());
        labelObject.setHeight(textObject.getHeight());
        labelObject.setWidth(textObject.getWidth());
        labelObject.setX(textObject.getX());
        labelObject.setY(textObject.getY());
        labelObject.setFontName(textObject.getOwnFontName());
        labelObject.setFontSize(textObject.getOwnFontsize());
        labelObject.setBackcolor(textObject.getOwnBackcolor());
        labelObject.setForecolor(textObject.getOwnForecolor());
        JRStyle originStyle = textObject.getStyle();
        labelObject.setStyle(originStyle);
        labelObject.setStyleNameReference(textObject.getStyleNameReference());
        labelObject.setBold(textObject.isOwnBold());
        labelObject.setItalic(textObject.isOwnItalic());
        labelObject.setUnderline(textObject.isOwnUnderline());
        labelObject.setStrikeThrough(textObject.isOwnStrikeThrough());
        labelObject.setHorizontalTextAlign(textObject.getOwnHorizontalTextAlign());
        labelObject.setVerticalTextAlign(textObject.getOwnVerticalTextAlign());
        labelObject.setMode(textObject.getOwnModeValue());
        labelObject.setRotation(textObject.getOwnRotationValue());
        labelObject.setStretchType(textObject.getStretchTypeValue());
        labelObject.setKey(textObject.getKey());
        labelObject.setMarkup(textObject.getOwnMarkup());
        labelObject.setPdfEmbedded(textObject.isOwnPdfEmbedded());
        labelObject.setPdfEncoding(textObject.getOwnPdfEncoding());
        labelObject.setPdfFontName(textObject.getOwnPdfFontName());
        labelObject.setPositionType(textObject.getPositionTypeValue());
        labelObject.setPrintInFirstWholeBand(textObject.isPrintInFirstWholeBand());
        labelObject.setPrintRepeatedValues(textObject.isPrintRepeatedValues());
        labelObject.setPrintWhenDetailOverflows(textObject.isPrintWhenDetailOverflows());
        this.cloneBox(labelObject.getLineBox(), textObject.getLineBox());
        this.cloneParagraph(labelObject.getParagraph(), textObject.getParagraph());
        JRExpression originExpression = textObject.getPrintWhenExpression();
        labelObject.setPrintWhenExpression(originExpression != null ? (JRExpression)originExpression.clone() : null);
        JRGroup originGroup = textObject.getPrintWhenGroupChanges();
        labelObject.setPrintWhenGroupChanges(originGroup != null ? (JRGroup)originGroup.clone() : null);
        labelObject.setRemoveLineWhenBlank(textObject.isRemoveLineWhenBlank());
        String[] stringArray = textObject.getPropertiesMap().getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            String propertyValue = textObject.getPropertiesMap().getProperty(propertyName);
            labelObject.getPropertiesMap().setProperty(propertyName, propertyValue);
            ++n2;
        }
        for (JRPropertyExpression propertyExpression : textObject.getPropertyExpressionsList()) {
            labelObject.addPropertyExpression((JRPropertyExpression)propertyExpression.clone());
        }
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionPartForType(TextFieldFigureEditPart.class);
        if (editparts.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        for (Object part : editparts) {
            TextFieldFigureEditPart editPart = (TextFieldFigureEditPart)part;
            MTextField textField = (MTextField)editPart.getModel();
            command.setReferenceNodeIfNull(textField);
            DeleteElementCommand deleteCommand = new DeleteElementCommand(textField);
            LazyCreateStaticTextCommand createCommand = new LazyCreateStaticTextCommand(textField);
            command.add(deleteCommand);
            command.add(createCommand);
        }
        return command;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    private class LazyCreateStaticTextCommand
    extends Command {
        private CreateElementCommand cmd = null;
        private ANode parent;
        private MTextField elementToCopy;
        private int oldIndex;

        public LazyCreateStaticTextCommand(MTextField elementToCopy) {
            this.elementToCopy = elementToCopy;
            this.parent = elementToCopy.getParent();
            this.oldIndex = ModelUtils.getChildrenPosition(elementToCopy);
        }

        public void execute() {
            MStaticText modelText = new MStaticText();
            JRDesignStaticText labelObject = (JRDesignStaticText)modelText.createJRElement(this.elementToCopy.getJasperDesign());
            JRDesignTextField textObject = (JRDesignTextField)this.elementToCopy.getValue();
            ConvertTextIntoStatic.this.cloneTextField(labelObject, textObject);
            modelText.setValue(labelObject);
            Rectangle position = new Rectangle(textObject.getX(), textObject.getY(), textObject.getWidth(), textObject.getHeight());
            this.cmd = new CreateElementCommand(this.parent, (MGraphicElement)modelText, position, this.oldIndex);
            this.cmd.setJasperDesign(this.parent.getJasperDesign());
            this.cmd.execute();
        }

        public void undo() {
            this.cmd.undo();
            this.cmd = null;
        }

        public boolean canExecute() {
            return this.elementToCopy != null && this.parent != null;
        }

        public boolean canUndo() {
            return this.cmd != null;
        }
    }
}

