/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.context;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.context.EditorContextUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditorContextCommand
extends AbstractHandler {
    public EditorContextCommand() {
        UIUtils.getDisplay().syncExec(this::listenSelection);
    }

    private void listenSelection() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService service = (ICommandService)w.getService(ICommandService.class);
        Command cmd = service.getCommand("com.jaspersoft.studio.editor.context.type");
        ISelectionService ss = w.getSelectionService();
        ss.addSelectionListener((part, selection) -> {
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IResource && this.isSelectable((IResource)obj)) {
                    this.setBaseEnabled(true);
                    cmd.setEnabled((Object)true);
                    try {
                        String p = ((IResource)obj).getPersistentProperty(EditorContextUtil.EC_KEY);
                        State state = cmd.getState("org.eclipse.ui.commands.radioState");
                        if (state != null) {
                            if (p == null) {
                                state.setValue((Object)"reset");
                            } else {
                                state.setValue((Object)Misc.nvl((Object)p, (String)"project"));
                            }
                        }
                    }
                    catch (CoreException e) {
                        JaspersoftStudioPlugin.getInstance().logError(e);
                    }
                    return;
                }
            }
            this.setBaseEnabled(false);
            cmd.setEnabled((Object)false);
        });
    }

    private boolean isSelectable(IResource obj) {
        return !(obj instanceof IFolder && obj.getName().equals("JR-INF") || obj.getParent() != null && !this.isSelectable((IResource)obj.getParent()));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (sel instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj instanceof IJavaProject) {
                obj = ((IJavaProject)obj).getProject();
            }
            if (obj instanceof IResource) {
                block6: {
                    if (!HandlerUtil.matchesRadioState((ExecutionEvent)event)) break block6;
                    return null;
                }
                try {
                    String state = event.getParameter("org.eclipse.ui.commands.radioStateParameter");
                    ((IResource)obj).setPersistentProperty(EditorContextUtil.EC_KEY, this.getPersistentState(state));
                    HandlerUtil.updateRadioState((Command)event.getCommand(), (String)state);
                    EditorContextUtil.fireContextChanged((IResource)obj, state);
                }
                catch (CoreException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
        }
        return null;
    }

    private String getPersistentState(String state) {
        if ("reset".equals(state)) {
            return null;
        }
        return state;
    }
}

