/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.context;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.editor.context.IResourceContextSwitchUtil;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditorContextUtil {
    public static QualifiedName EC_KEY = new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), "editor.context");
    private static final boolean EDGE_PROBLEM_FOUND = UIUtils.isWindows() && !BrowserUtils.isEdgeWebViewEnabled();
    public static boolean ENABLEMENU = false;
    private static List<ContextSwitchAction> actions = new ArrayList<ContextSwitchAction>();
    private static Map<AbstractJRXMLEditor, Label> labels = new HashMap<AbstractJRXMLEditor, Label>();

    public static void fireContextChanged(IResource r, String state) {
        if (ENABLEMENU) {
            for (ContextSwitchAction csa : actions) {
                csa.refresh(r);
            }
        } else {
            for (AbstractJRXMLEditor editor : labels.keySet()) {
                JasperReportsConfiguration jConf = editor.getJrContext();
                AEditorContext old = jConf.getEditorContext();
                IFile f = (IFile)jConf.get("ifile");
                AEditorContext ec = EditorContextUtil.getEditorContext(f, jConf);
                if (old.getClass().equals(ec.getClass())) continue;
                editor.changeContext(ec.getId(), !r.equals((Object)f));
                Label lbl = labels.get(editor);
                if (lbl.isDisposed()) continue;
                lbl.setText(editor.getJrContext().getEditorContext().getName());
                lbl.getParent().pack();
                lbl.getParent().getParent().update();
                lbl.getParent().getParent().layout(true);
            }
        }
        Collection<IResourceContextSwitchUtil> allUtils = JaspersoftStudioPlugin.getExtensionManager().getAllEditorContextUtils();
        for (IResourceContextSwitchUtil u : allUtils) {
            u.essentialOperations(r, state);
        }
    }

    public static AEditorContext getEditorContext(IFile f, JasperReportsConfiguration jConf) {
        String ctx = null;
        try {
            if (f != null) {
                if (f.exists() && ENABLEMENU) {
                    ctx = f.getPersistentProperty(EC_KEY);
                }
                IContainer c = f.getParent();
                while (c != null && Misc.isNullOrEmpty((String)ctx) && c.exists()) {
                    ctx = c.getPersistentProperty(EC_KEY);
                    c = c.getParent();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        AEditorContext ec = JaspersoftStudioPlugin.getExtensionManager().getEditorContext(ctx, f);
        ec.init(f, jConf);
        return ec;
    }

    private static String getParentContext(IResource f) {
        String ctx = null;
        if (f != null) {
            try {
                ctx = f.getPersistentProperty(EC_KEY);
                IContainer c = f.getParent();
                while (c != null && Misc.isNullOrEmpty((String)ctx)) {
                    ctx = c.getPersistentProperty(EC_KEY);
                    c = c.getParent();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return Misc.nvl(ctx, (String)"project");
    }

    public static Control createSwitch(Composite cmp, AbstractJRXMLEditor editor) {
        if (ENABLEMENU) {
            ToolBar toolBar = new ToolBar(cmp, 0x800000);
            toolBar.setBackgroundMode(2);
            ToolBarManager tbManager = new ToolBarManager(toolBar);
            tbManager.add((IAction)new ContextSwitchAction(editor, toolBar, tbManager));
            tbManager.update(true);
            toolBar.pack();
            return toolBar;
        }
        int numColumns = 1;
        if (EDGE_PROBLEM_FOUND) {
            numColumns = 3;
        }
        Composite container = new Composite(cmp, 0);
        GridLayout containerGL = new GridLayout(numColumns, false);
        container.setLayout((Layout)containerGL);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        if (EDGE_PROBLEM_FOUND) {
            Label warningLbl = new Label(container, 0);
            GridData warningLblGD = new GridData(4, 0x1000000, true, false);
            warningLbl.setText(Messages.EditorContextUtil_EdgeWarningMsg);
            warningLbl.setForeground(UIUtils.getDisplay().getSystemColor(3));
            warningLbl.setLayoutData((Object)warningLblGD);
            Label separator = new Label(container, 514);
            GridData sepGD = new GridData(4, 4, true, false);
            sepGD.heightHint = 20;
            separator.setLayoutData((Object)sepGD);
        }
        Label contextNameLbl = new Label(container, 0);
        if (editor.getJrContext() != null) {
            GridData contextNameLblGD = new GridData(4, 0x1000000, true, false);
            contextNameLbl.setLayoutData((Object)contextNameLblGD);
            contextNameLbl.setText(editor.getJrContext().getEditorContext().getName());
        }
        labels.put(editor, contextNameLbl);
        contextNameLbl.addDisposeListener(e -> {
            Label label = labels.remove(editor);
        });
        return container;
    }

    public static class ContextSwitchAction
    extends Action
    implements IMenuCreator {
        private AbstractJRXMLEditor editor;
        private ToolBar toolBar;
        private ToolBarManager tbManager;
        private Menu menu;

        public ContextSwitchAction(AbstractJRXMLEditor editor, ToolBar toolBar, ToolBarManager tbManager) {
            this.toolBar = toolBar;
            this.tbManager = tbManager;
            this.setText(Messages.EditorContextUtil_0);
            UIUtils.getDisplay().asyncExec(() -> {
                if (editor.getJrContext() != null) {
                    this.setToolBarText(editor.getJrContext().getEditorContext().getName());
                } else {
                    this.setToolBarText("project");
                }
            });
            this.setMenuCreator(this);
            this.editor = editor;
            actions.add(this);
            toolBar.addDisposeListener(e -> {
                boolean bl = actions.remove((Object)this);
            });
        }

        private void setToolBarText(String text) {
            if (this.toolBar.isDisposed()) {
                return;
            }
            this.setText(Misc.nvl((Object)text, (String)"project"));
            if (this.editor.getJrContext() != null) {
                IFile f = (IFile)this.editor.getJrContext().get("ifile");
                try {
                    if (f == null || f.getPersistentProperty(EC_KEY) == null) {
                        this.setToolTipText(Messages.EditorContextUtil_1);
                    } else {
                        this.setToolTipText(Messages.EditorContextUtil_2);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.tbManager.update(true);
            this.toolBar.pack();
            this.toolBar.getParent().update();
            this.toolBar.getParent().layout(true);
        }

        public void runWithEvent(Event event) {
            Point point = ((ToolItem)event.widget).getParent().toDisplay(new Point(event.x, event.y));
            this.menu = this.getMenu((Control)((ToolItem)event.widget).getParent());
            this.menu.setLocation(point.x, point.y);
            this.menu.setVisible(true);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                IFile f = (IFile)this.editor.getJrContext().get("ifile");
                String ct = null;
                try {
                    ct = f.getPersistentProperty(EC_KEY);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                List<KeyValue<String, String>> ecs = JaspersoftStudioPlugin.getExtensionManager().getEditorContexts();
                for (KeyValue<String, String> item : ecs) {
                    final MenuItem mi = new MenuItem(this.menu, 32);
                    mi.setText((String)item.value);
                    mi.setData("name", item.key);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String n = (String)mi.getData("name");
                            IFile f = (IFile)editor.getJrContext().get("ifile");
                            String ct = null;
                            try {
                                ct = f.getPersistentProperty(EC_KEY);
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                            }
                            if (ct == null || !ct.equals(n)) {
                                editor.changeContext(n, false);
                                this.setToolBarText(mi.getText());
                            }
                            MenuItem[] menuItemArray = menu.getItems();
                            int n2 = menuItemArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                MenuItem m = menuItemArray[n3];
                                if (m.getData("name") != null) {
                                    m.setSelection(false);
                                }
                                ++n3;
                            }
                            mi.setSelection(true);
                        }
                    });
                    if (ct == null || !ct.equals(item.key)) continue;
                    mi.setSelection(true);
                }
                if (ecs.size() > 1) {
                    new MenuItem(this.menu, 2);
                    MenuItem mi = new MenuItem(this.menu, 8);
                    mi.setText(Messages.EditorContextUtil_6);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MenuItem[] menuItemArray = menu.getItems();
                            int n = menuItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem m = menuItemArray[n2];
                                if (m.getData("name") != null) {
                                    m.setSelection(false);
                                }
                                ++n2;
                            }
                            IFile f = (IFile)editor.getJrContext().get("ifile");
                            editor.changeContext(EditorContextUtil.getParentContext((IResource)f.getParent()), true);
                            this.setToolBarText(editor.getJrContext().getEditorContext().getName());
                        }
                    });
                }
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void refresh(IResource resource) {
            JasperReportsConfiguration jConf = this.editor.getJrContext();
            AEditorContext old = jConf.getEditorContext();
            IFile f = (IFile)jConf.get("ifile");
            AEditorContext ec = EditorContextUtil.getEditorContext(f, jConf);
            if (old.getClass().equals(ec.getClass())) {
                return;
            }
            this.editor.changeContext(ec.getId(), !resource.equals((Object)f));
            this.setToolBarText(jConf.getEditorContext().getName());
        }
    }
}

