/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.context;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.eclipse.core.resources.IFile;

public class JSSDefaultRepositoryService
extends DefaultRepositoryService {
    private JasperReportsConfiguration jConf;

    public JSSDefaultRepositoryService(JasperReportsConfiguration jConf) {
        super((JasperReportsContext)jConf);
        this.jConf = jConf;
    }

    public InputStream getInputStream(RepositoryContext context, String uri) {
        if (Misc.isNullOrEmpty((String)uri) || uri.startsWith("repo:")) {
            return null;
        }
        try {
            URL url = JRResourcesUtil.createURL((String)uri, (URLStreamHandlerFactory)this.urlHandlerFactory);
            if (url != null) {
                if (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) {
                    try {
                        URI uuri = url.toURI();
                        Executor exec = Executor.newInstance();
                        HttpUtils.setupProxy((Executor)exec, (URI)uuri);
                        Request req = Request.Get((URI)uuri);
                        HttpUtils.setupProxy((Executor)exec, (URI)uuri, (Request)req);
                        return exec.execute(req).returnContent().asStream();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        throw new JRRuntimeException("util.loader.input.stream.from.url.open.error", new Object[]{url}, (Throwable)e);
                    }
                }
                return JRLoader.getInputStream((URL)url);
            }
            File file = JRResourcesUtil.resolveFile((RepositoryContext)SimpleRepositoryContext.of((JasperReportsContext)this.jConf), (String)uri);
            if (file != null) {
                return JRLoader.getInputStream((File)file);
            }
            url = JRResourcesUtil.findClassLoaderResource((String)uri, (ClassLoader)this.classLoader);
            if (url != null) {
                return JRLoader.getInputStream((URL)url);
            }
            File relativeFile = FileUtils.findFile((IFile)this.jConf.getAssociatedReportFile(), (String)uri);
            if (relativeFile != null && relativeFile.exists()) {
                return JRLoader.getInputStream((File)relativeFile);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        return super.getInputStream(context, uri);
    }
}

