/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.dnd;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.dnd.ImageURLTransfer;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.image.command.CreateImageCommand;
import com.jaspersoft.studio.repository.IRepositoryViewProvider;
import com.jaspersoft.studio.utils.ImageUtils;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ImageResourceDropTargetListener
extends AbstractTransferDropTargetListener {
    private SimpleImageCreationFactory factory = new SimpleImageCreationFactory();

    public ImageResourceDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public ImageResourceDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected void updateTargetRequest() {
        ((CreateRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (event.data != null) {
            return this.isDroppedDataAnImage(event);
        }
        return super.isEnabled(event);
    }

    private boolean isDroppedDataAnImage(DropTargetEvent event) {
        if (ResourceTransfer.getInstance().isSupportedType(event.currentDataType)) {
            if (event.data instanceof IResource[]) {
                IResource imgResource = ((IResource[])event.data)[0];
                String extension = imgResource.getProjectRelativePath().getFileExtension();
                return ImageUtils.hasValidFileImageExtension(extension) || extension.equalsIgnoreCase("svg");
            }
        } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            int lastIndexOfDot;
            String filepath;
            if (event.data instanceof String[] && (filepath = ((String[])event.data)[0]) != null && (lastIndexOfDot = filepath.lastIndexOf(".")) != -1) {
                String extension = filepath.substring(lastIndexOfDot + 1);
                return ImageUtils.hasValidFileImageExtension(extension) || extension.equalsIgnoreCase("svg");
            }
        } else if (ImageURLTransfer.getInstance().isSupportedType(event.currentDataType)) {
            return event.data instanceof String;
        }
        return false;
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null) {
            Command command = this.getCommand();
            if (command instanceof CreateImageCommand && command.canExecute()) {
                try {
                    command = this.setImageExpression((CreateImageCommand)command);
                    this.getViewer().getEditDomain().getCommandStack().execute(command);
                }
                catch (InterruptedException interruptedException) {
                    this.getCurrentEvent().detail = 0;
                }
            } else {
                this.getCurrentEvent().detail = 0;
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
    }

    private Command setImageExpression(CreateImageCommand command) throws InterruptedException {
        String filepath;
        DropTargetEvent cevt = this.getCurrentEvent();
        if (cevt.data == null) {
            return null;
        }
        if (ResourceTransfer.getInstance().isSupportedType(cevt.currentDataType)) {
            IResource imgResource = ((IResource[])cevt.data)[0];
            String expression = "\"" + imgResource.getProjectRelativePath() + "\"";
            command.setImageExpression(new JRDesignExpression(expression));
        } else if (FileTransfer.getInstance().isSupportedType(cevt.currentDataType)) {
            String filepath2 = ((String[])cevt.data)[0];
            if (filepath2 != null) {
                String expression = "\"" + filepath2 + "\"";
                command.setImageExpression(new JRDesignExpression(expression));
            }
        } else if (ImageURLTransfer.getInstance().isSupportedType(cevt.currentDataType) && (filepath = (String)cevt.data) != null) {
            String expr = filepath;
            command.setImageExpression(new JRDesignExpression("\"" + expr.trim() + "\""));
            int indx = filepath.lastIndexOf("\n");
            if (indx > 0) {
                expr = filepath.substring(indx).trim();
                command.setImageExpression(new JRDesignExpression("\"" + expr.trim() + "\""));
                String srv = filepath.substring(0, indx);
                ISelection s = this.getViewer().getSelection();
                if (s instanceof StructuredSelection) {
                    Object obj = ((StructuredSelection)s).getFirstElement();
                    if (obj instanceof EditPart) {
                        obj = ((EditPart)obj).getModel();
                    }
                    if (obj instanceof APropertyNode) {
                        INode r = ((APropertyNode)obj).getRoot();
                        CompoundCommand cc = new CompoundCommand(command.getLabel());
                        if (r != null) {
                            JaspersoftStudioPlugin.getInstance();
                            for (IRepositoryViewProvider rvp : JaspersoftStudioPlugin.getExtensionManager().getRepositoryProviders()) {
                                List<Command> c = rvp.dropResource(srv, r);
                                if (Misc.isNullOrEmpty(c)) continue;
                                for (Command item : c) {
                                    cc.add(item);
                                }
                            }
                        }
                        if (!cc.isEmpty()) {
                            cc.add((Command)command);
                            return cc;
                        }
                    }
                }
            }
        }
        return command;
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory((CreationFactory)this.factory);
        return request;
    }

    private class SimpleImageCreationFactory
    implements CreationFactory {
        private SimpleImageCreationFactory() {
        }

        public Object getNewObject() {
            return new MImage();
        }

        public Object getObjectType() {
            return MImage.class;
        }
    }
}

