/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.dnd;

import com.jaspersoft.studio.utils.SelectionHelper;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class ImageURLTransfer
extends ByteArrayTransfer {
    private static final ImageURLTransfer instance = new ImageURLTransfer();
    private static final String ID_NAME = "image-url-transfer";
    private static final int ID = ImageURLTransfer.registerType((String)"image-url-transfer");

    private ImageURLTransfer() {
    }

    public static ImageURLTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{ID};
    }

    protected String[] getTypeNames() {
        return new String[]{ID_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] byteArray = ((String)object).getBytes(ImageURLTransfer.getCurrentCharset());
        if (byteArray != null) {
            super.javaToNative((Object)byteArray, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (this.isSupportedType(transferData) && bytes != null) {
            return new String(bytes, ImageURLTransfer.getCurrentCharset());
        }
        return null;
    }

    private static Charset getCurrentCharset() {
        IFile currFile;
        Charset currCharset = Charset.defaultCharset();
        IEditorPart ep = SelectionHelper.getActiveJRXMLEditor();
        if (ep != null && ep.getEditorInput() instanceof IFileEditorInput && (currFile = ((IFileEditorInput)ep.getEditorInput()).getFile()) != null) {
            try {
                currCharset = Charset.forName(currFile.getCharset());
            }
            catch (CoreException e) {
                NLS.bind((String)"Unable to provide support for the file charset.", (Object)((Object)e));
            }
        }
        return currCharset;
    }
}

