/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.WizardDialog;

public class EditElementExpressionCommand
extends Command {
    private JasperDesign jasperDesign;
    private APropertyNode editedElement;
    private String propertyName;
    private JRDesignExpression originalExpression;
    private JRDesignExpression newExpression;
    private boolean isExpressionChanged;

    public EditElementExpressionCommand(APropertyNode textField, String propertyName) {
        this.editedElement = textField;
        this.jasperDesign = this.editedElement.getJasperDesign();
        this.propertyName = propertyName;
        this.originalExpression = (JRDesignExpression)this.editedElement.getPropertyValue(propertyName);
        this.isExpressionChanged = false;
    }

    public boolean canExecute() {
        return this.editedElement != null && this.jasperDesign != null;
    }

    public void execute() {
        this.editedElement.setPropertyValue(this.propertyName, this.newExpression);
    }

    public int showDialog() {
        if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
            JRExpressionEditor wizard = new JRExpressionEditor();
            wizard.setValue((JRDesignExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.originalExpression));
            ExpressionContext ec = null;
            ec = this.editedElement.getValue() instanceof JRDesignElement ? ModelUtils.getElementExpressionContext((JRDesignElement)this.editedElement.getValue(), this.editedElement) : (this.editedElement instanceof MParameter ? ((MParameter)this.editedElement).getExpressionContext() : (this.editedElement instanceof MVariable ? ((MVariable)this.editedElement).getExpressionContext() : ExpressionContext.getGlobalContext()));
            wizard.setExpressionContext(ec);
            WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(UIUtils.getShell(), wizard);
            if (dialog.open() == 0) {
                this.isExpressionChanged = true;
                this.newExpression = wizard.getValue();
                return 0;
            }
        }
        this.isExpressionChanged = false;
        return 1;
    }

    public boolean canRedo() {
        return this.isExpressionChanged;
    }

    public boolean canUndo() {
        return this.isExpressionChanged;
    }

    public void undo() {
        this.editedElement.setPropertyValue(this.propertyName, this.originalExpression);
    }

    public String getLabel() {
        return "Change Text Field Expression";
    }
}

