/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.expression;

import com.jaspersoft.studio.utils.ModelUtils;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import org.eclipse.core.runtime.Assert;

public class ExpObject
implements Comparable<ExpObject> {
    public static final int TYPE_FIELD = 0;
    public static final int TYPE_VARIABLE = 1;
    public static final int TYPE_PARAM = 2;
    public static final int TYPE_RBKEY = 3;
    private String name = "";
    private int type = 0;
    private String classType = "java.lang.String";

    public ExpObject(String name, int type, String classType) {
        this.setName(name);
        this.setType(type);
        this.setClassType(classType);
    }

    public ExpObject() {
    }

    public ExpObject(Object obj) {
        if (obj instanceof JRField) {
            this.name = ((JRField)obj).getName();
            this.type = 0;
            this.classType = ((JRField)obj).getValueClassName();
        } else if (obj instanceof JRParameter) {
            this.name = ((JRParameter)obj).getName();
            this.type = 2;
            this.classType = ((JRParameter)obj).getValueClassName();
        } else if (obj instanceof JRVariable) {
            this.name = ((JRVariable)obj).getName();
            this.type = 1;
            this.classType = ((JRVariable)obj).getValueClassName();
        } else {
            this.name = "" + obj;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getClassType() {
        if (this.classType == null || this.classType.isEmpty()) {
            this.classType = "java.lang.Object";
        }
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public String getExpression() {
        if (this.getType() == 0) {
            return "$F{" + this.getName() + "}";
        }
        if (this.getType() == 1) {
            return "$V{" + this.getName() + "}";
        }
        if (this.getType() == 2) {
            return "$P{" + this.getName() + "}";
        }
        if (this.getType() == 3) {
            return "$R{" + this.getName() + "}";
        }
        return this.getName();
    }

    @Override
    public int compareTo(ExpObject arg0) {
        return this.getExpression().compareTo(arg0.getExpression());
    }

    public static boolean isValidExpressionObj(String expressionTxt, JRField field) {
        Assert.isNotNull((Object)expressionTxt);
        Assert.isNotNull((Object)field);
        return expressionTxt.equals(ModelUtils.getNameAsField(field.getName()));
    }

    public static boolean isValidExpressionObj(String expressionTxt, JRVariable variable) {
        Assert.isNotNull((Object)expressionTxt);
        Assert.isNotNull((Object)variable);
        return expressionTxt.equals(ModelUtils.getNameAsVariable(variable.getName()));
    }

    public static boolean isValidExpressionObj(String expressionTxt, JRParameter parameter) {
        Assert.isNotNull((Object)expressionTxt);
        Assert.isNotNull((Object)parameter);
        return expressionTxt.equals(ModelUtils.getNameAsParameter(parameter.getName()));
    }
}

