/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.commands.Command;

public class Align2ElementCommand
extends Command {
    private int alignement;
    private MGraphicElement primary;
    private List<MGraphicElement> selection;
    private List<SetValueCommand> setPositionCommands;

    public Align2ElementCommand(int alignement, MGraphicElement primary, List<MGraphicElement> selection) {
        this.alignement = alignement;
        this.primary = primary;
        this.selection = selection;
    }

    public boolean canExecute() {
        return this.primary != null && this.selection != null && this.selection.size() > 1;
    }

    public boolean canUndo() {
        return this.setPositionCommands != null;
    }

    public void execute() {
        this.setPositionCommands = new ArrayList<SetValueCommand>();
        JRDesignElement designElement = this.primary.getValue();
        for (MGraphicElement mGraphicElement : this.selection) {
            if (mGraphicElement == this.primary) continue;
            JRDesignElement selected = mGraphicElement.getValue();
            switch (this.alignement) {
                case 1: {
                    this.createCommand("x", mGraphicElement, designElement.getX());
                    break;
                }
                case 4: {
                    int rightPost = designElement.getX() + designElement.getWidth() - selected.getWidth();
                    this.createCommand("x", mGraphicElement, rightPost);
                    break;
                }
                case 8: {
                    this.createCommand("y", mGraphicElement, designElement.getY());
                    break;
                }
                case 32: {
                    int bottomPos = designElement.getY() + designElement.getHeight() - selected.getHeight();
                    this.createCommand("y", mGraphicElement, bottomPos);
                    break;
                }
                case 2: {
                    int centerVert = designElement.getX() + Math.abs(designElement.getWidth() - selected.getWidth()) / 2;
                    this.createCommand("x", mGraphicElement, centerVert);
                    break;
                }
                case 16: {
                    int middle = designElement.getY() + Math.abs(designElement.getHeight() - selected.getHeight()) / 2;
                    this.createCommand("y", mGraphicElement, middle);
                    break;
                }
            }
        }
        for (Command command : this.setPositionCommands) {
            command.execute();
        }
    }

    private void createCommand(String property, MGraphicElement destination, Object value) {
        SetValueCommand newCommand = new SetValueCommand();
        newCommand.setTarget(destination);
        newCommand.setPropertyValue(value);
        newCommand.setPropertyId(property);
        this.setPositionCommands.add(newCommand);
    }

    public void undo() {
        for (SetValueCommand undoCommand : this.setPositionCommands) {
            undoCommand.undo();
        }
        this.setPositionCommands = null;
    }
}

