/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.band.MBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class ResizeCommand
extends Command {
    private int alignement;
    private Dimension parent;
    private JRDesignElement jrElement;
    private int oldX;
    private int oldY;
    private int oldWidth;
    private int oldHeight;

    public ResizeCommand(int alignement, EditPart editPart) {
        this(alignement, (MGraphicElement)editPart.getModel());
    }

    public ResizeCommand(int alignement, MGraphicElement m) {
        this.alignement = alignement;
        this.jrElement = m.getValue();
        ANode n = m.getParent();
        if (n instanceof MPage) {
            MPage page = (MPage)n;
            n = page.getRealParent();
        }
        if (n instanceof IContainer) {
            if (n instanceof MBand) {
                JRDesignBand band = ((MBand)n).getValue();
                int h = band.getHeight();
                JasperDesign jasperDesign = m.getJasperDesign();
                int w = jasperDesign.getPageWidth() - jasperDesign.getLeftMargin() - jasperDesign.getRightMargin();
                this.parent = new Dimension(w, h);
            } else if (n instanceof IGraphicElementContainer) {
                this.parent = ((IGraphicElementContainer)((Object)n)).getSize();
            }
        }
    }

    public void execute() {
        this.oldX = this.jrElement.getX();
        this.oldY = this.jrElement.getY();
        this.oldWidth = this.jrElement.getWidth();
        this.oldHeight = this.jrElement.getHeight();
        int newX = this.oldX;
        int newY = this.oldY;
        int newWidth = this.oldWidth;
        int newHeight = this.oldHeight;
        switch (this.alignement) {
            case 0: {
                newX = 0;
                newWidth = this.parent.width;
                break;
            }
            case 1: {
                newY = 0;
                newHeight = this.parent.height;
                break;
            }
            case 2: {
                newX = 0;
                newY = 0;
                newWidth = this.parent.width;
                newHeight = this.parent.height;
            }
        }
        this.jrElement.setX(newX);
        this.jrElement.setY(newY);
        this.jrElement.setWidth(newWidth);
        this.jrElement.setHeight(newHeight);
    }

    public void undo() {
        this.jrElement.setX(this.oldX);
        this.jrElement.setY(this.oldY);
        this.jrElement.setWidth(this.oldWidth);
        this.jrElement.setHeight(this.oldHeight);
    }
}

