/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetConstraintCommand
extends Command {
    private ANode originalParent;
    private ANode newParent;
    private Rectangle newBounds;
    private Rectangle oldBounds;
    private int oldIndex;
    private JRDesignElement jrElement;
    private JasperDesign jrDesign;
    private JasperReportsConfiguration jrConfig;
    private Rectangle parentBounds;
    protected JRElementGroup jrGroup;
    private int oldBandHeight = -1;

    public void setContext(ANode parent, ANode child, Rectangle constraint) {
        this.jrConfig = child.getJasperConfiguration();
        this.jrDesign = this.jrConfig.getJasperDesign();
        this.originalParent = child.getParent();
        this.newParent = parent instanceof MBand ? parent : this.originalParent;
        if (child.getValue() instanceof JRDesignElement) {
            this.jrElement = (JRDesignElement)child.getValue();
            this.oldBounds = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
            this.newBounds = constraint;
            this.parentBounds = ((IGraphicElement)((Object)child)).getBounds();
            if (child instanceof IGroupElement) {
                this.jrGroup = ((IGroupElement)((Object)child)).getJRElementGroup();
            } else if (child.getValue() instanceof JRElementGroup) {
                this.jrGroup = (JRElementGroup)child.getValue();
            }
        }
    }

    private boolean isOperationAllowed(Rectangle oldBounds, Rectangle newBounds) {
        String parentLayout;
        JRPropertiesMap newMap = LayoutManager.getPropertyMap(this.originalParent);
        if (newMap != null && this.jrElement != null && (parentLayout = newMap.getProperty("com.jaspersoft.studio.layout")) != null) {
            ILayout layout = LayoutManager.getLayout(parentLayout);
            Rectangle relativeNewBounds = new Rectangle(newBounds);
            int x = this.jrElement.getX() + newBounds.x - this.parentBounds.x;
            int y = this.jrElement.getY() + newBounds.y - this.parentBounds.y;
            relativeNewBounds.setX(x);
            relativeNewBounds.setY(y);
            return layout.allowChildBoundChange(this.getNodeForElement(this.originalParent), oldBounds, relativeNewBounds);
        }
        return true;
    }

    private ANode getNodeForElement(ANode parent) {
        for (INode child : parent.getChildren()) {
            if (child.getValue() != this.jrElement) continue;
            return (ANode)child;
        }
        return null;
    }

    public boolean canExecute() {
        return this.isOperationAllowed(this.oldBounds, this.newBounds);
    }

    public void execute() {
        if (this.jrElement != null) {
            int x = this.jrElement.getX() + this.newBounds.x - this.parentBounds.x;
            int y = this.jrElement.getY() + this.newBounds.y - this.parentBounds.y;
            if (this.newParent != this.originalParent) {
                this.changeParent((JRDesignBand)this.originalParent.getValue(), (JRDesignBand)this.newParent.getValue());
            }
            this.jrElement.setX(x);
            this.jrElement.setY(y);
            this.jrElement.setWidth(this.newBounds.width);
            this.jrElement.setHeight(this.newBounds.height);
            if (this.newParent != null && this.newParent.getValue() != null && this.newParent.getValue() instanceof JRDesignBand) {
                JRDesignBand band = (JRDesignBand)this.newParent.getValue();
                int maxHeight = ModelUtils.getMaxBandHeight(band, this.jrDesign);
                int elementHeight = this.jrElement.getHeight() + this.jrElement.getY();
                boolean isBandResizeEnabled = this.jrConfig.getPropertyBoolean("resizeParentContainer", Boolean.TRUE);
                if (maxHeight > 1 && elementHeight > band.getHeight() && isBandResizeEnabled) {
                    this.oldBandHeight = band.getHeight();
                    int elHeight = this.jrElement.getY() + this.jrElement.getHeight();
                    if ((elHeight = Math.min(maxHeight, elHeight)) > band.getHeight()) {
                        band.setHeight(elHeight);
                    }
                }
            }
            this.layoutChildAndParent(this.newParent);
        }
    }

    private void layoutChildAndParent(ANode currentParent) {
        ANode elementNode = this.getNodeForElement(currentParent);
        LayoutManager.layoutContainer(elementNode);
        LayoutManager.layoutContainer(currentParent);
    }

    private void changeParent(JRDesignBand originalBand, JRDesignBand destinationBand) {
        JRElement[] elements = originalBand.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == this.jrElement) {
                this.oldIndex = i;
                break;
            }
            ++i;
        }
        originalBand.removeElement(this.jrElement);
        destinationBand.addElement(this.jrElement);
    }

    public void undo() {
        if (this.originalParent != this.newParent) {
            JRDesignBand originalBand = (JRDesignBand)this.originalParent.getValue();
            JRDesignBand newBand = (JRDesignBand)this.newParent.getValue();
            newBand.removeElement(this.jrElement);
            originalBand.addElement(this.oldIndex, this.jrElement);
        }
        this.jrElement.setX(this.oldBounds.x);
        this.jrElement.setY(this.oldBounds.y);
        this.jrElement.setWidth(this.oldBounds.width);
        this.jrElement.setHeight(this.oldBounds.height);
        if (this.oldBandHeight != -1) {
            JRDesignBand newBand = (JRDesignBand)this.newParent.getValue();
            newBand.setHeight(this.oldBandHeight);
        }
        this.layoutChildAndParent(this.originalParent);
    }

    public String getLabel() {
        if (this.oldBounds != null && (this.oldBounds.x != this.newBounds.x || this.oldBounds.y != this.newBounds.y)) {
            return "set location";
        }
        return "resize";
    }
}

