/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.commands;

import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetPageConstraintCommand
extends Command {
    private Rectangle newBounds;
    private Rectangle oldBounds;
    private JRDesignElement jrElement;
    private Rectangle parentBounds;
    protected JRElementGroup jrGroup;
    private ANode parent;

    public void setContext(ANode parent, ANode child, Rectangle constraint) {
        if (child.getValue() instanceof JRDesignElement) {
            this.jrElement = (JRDesignElement)child.getValue();
            this.newBounds = constraint;
            this.parentBounds = ((IGraphicElement)((Object)child)).getBounds();
            this.parent = parent = child.getParent();
            if (parent instanceof IGroupElement) {
                this.jrGroup = ((IGroupElement)((Object)parent)).getJRElementGroup();
            } else if (parent.getValue() instanceof JRElementGroup) {
                this.jrGroup = (JRElementGroup)parent.getValue();
            }
        }
    }

    public void setContext2(ANode parent, ANode child, Rectangle constraint) {
        if (child.getValue() instanceof JRDesignElement) {
            this.jrElement = (JRDesignElement)child.getValue();
            this.newBounds = constraint;
            this.parentBounds = ((IGraphicElement)((Object)child)).getBounds();
            if (parent instanceof IGroupElement) {
                this.jrGroup = ((IGroupElement)((Object)parent)).getJRElementGroup();
            } else if (parent.getValue() instanceof JRElementGroup) {
                this.jrGroup = (JRElementGroup)parent.getValue();
            }
        }
    }

    public void execute() {
        if (this.jrElement != null) {
            this.oldBounds = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
            int y = this.jrElement.getY() + this.newBounds.y - this.parentBounds.y;
            int x = this.jrElement.getX() + this.newBounds.x - this.parentBounds.x;
            this.jrElement.setX(x);
            this.jrElement.setY(y);
            this.jrElement.setWidth(this.newBounds.width);
            this.jrElement.setHeight(this.newBounds.height);
            this.layoutChildAndParent(this.parent);
        }
    }

    public void undo() {
        if (this.jrElement != null) {
            this.jrElement.setWidth(this.oldBounds.width);
            this.jrElement.setHeight(this.oldBounds.height);
            this.jrElement.setX(this.oldBounds.x);
            this.jrElement.setY(this.oldBounds.y);
            this.layoutChildAndParent(this.parent);
        }
    }

    public String getLabel() {
        if (this.oldBounds != null && (this.oldBounds.x != this.newBounds.x || this.oldBounds.y != this.newBounds.y)) {
            return "set location";
        }
        return "resize";
    }

    private boolean isOperationAllowed(Rectangle oldBounds, Rectangle newBounds) {
        String parentLayout;
        JRPropertiesMap newMap = LayoutManager.getPropertyMap(this.parent);
        if (newMap != null && (parentLayout = newMap.getProperty("com.jaspersoft.studio.layout")) != null) {
            ILayout layout = LayoutManager.getLayout(parentLayout);
            return layout.allowChildBoundChange(this.getNodeForElement(this.parent), oldBounds, newBounds);
        }
        return true;
    }

    private ANode getNodeForElement(ANode parent) {
        for (INode child : parent.getChildren()) {
            if (child.getValue() != this.jrElement) continue;
            return (ANode)child;
        }
        return null;
    }

    public boolean canExecute() {
        if (this.oldBounds == null && this.jrElement != null) {
            this.oldBounds = new Rectangle(this.jrElement.getX(), this.jrElement.getY(), this.jrElement.getWidth(), this.jrElement.getHeight());
        }
        return this.isOperationAllowed(this.oldBounds, this.newBounds);
    }

    private void layoutChildAndParent(ANode currentParent) {
        ANode elementNode = this.getNodeForElement(currentParent);
        LayoutManager.layoutContainer(elementNode);
        LayoutManager.layoutContainer(currentParent);
    }
}

