/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator;

import com.jaspersoft.studio.editor.gef.decorator.IElementDecorator;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.RetargetAction;

public class DecoratorManager {
    private List<IElementDecorator> elementDecorators = new ArrayList<IElementDecorator>();

    public void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.jaspersoft.studio", "decorators");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("ClassFactory");
                if (o instanceof IElementDecorator) {
                    if ("com.jaspersoft.studio".equalsIgnoreCase(e.getContributor().getName())) {
                        this.elementDecorators.add(0, (IElementDecorator)o);
                    } else {
                        this.elementDecorators.add((IElementDecorator)o);
                    }
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    public void setupFigure(ComponentFigure fig, FigureEditPart editPart) {
        for (IElementDecorator f : this.elementDecorators) {
            f.setupFigure(fig, editPart);
        }
    }

    public void registerActions(ActionRegistry registry, List<String> selectionActions, GraphicalViewer gviewer, AbstractVisualEditor part) {
        for (IElementDecorator f : this.elementDecorators) {
            f.registerActions(registry, selectionActions, gviewer, part);
        }
    }

    public List<IElementDecorator> getDecorators() {
        return this.elementDecorators;
    }

    public void buildContextMenu(ActionRegistry registry, EditPartViewer viewer, IMenuManager menu) {
        for (IElementDecorator f : this.elementDecorators) {
            f.buildContextMenu(registry, viewer, menu);
        }
    }

    public List<RetargetAction> buildMenuActions() {
        ArrayList<RetargetAction> actions = new ArrayList<RetargetAction>();
        for (IElementDecorator f : this.elementDecorators) {
            actions.addAll(Arrays.asList(f.buildMenuActions()));
        }
        return actions;
    }

    public void contribute2Menu(ActionRegistry registry, MenuManager menuManager) {
        for (IElementDecorator f : this.elementDecorators) {
            f.contribute2Menu(registry, menuManager);
        }
    }

    public List<String> getActionIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (IElementDecorator f : this.elementDecorators) {
            ids.addAll(f.getActionIDs());
        }
        return ids;
    }
}

