/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.chainable;

import com.jaspersoft.studio.editor.gef.decorator.IDecorator;
import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import com.jaspersoft.studio.editor.gef.decorator.chainable.IDecoratorInterface;
import com.jaspersoft.studio.editor.gef.decorator.pdf.PDFDecorator;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

public class ChainableDecorator
implements IDecorator {
    private static ImageIcon startImageAwt = null;
    private static ImageIcon endImageAwt = null;
    private ArrayList<IDecoratorInterface> textDecorators = new ArrayList();

    public ChainableDecorator() {
        if (startImageAwt == null || endImageAwt == null) {
            startImageAwt = new ImageIcon(PDFDecorator.class.getResource("/icons/resources/corner1.png"));
            endImageAwt = new ImageIcon(PDFDecorator.class.getResource("/icons/resources/corner2.png"));
        }
    }

    public void addDecorator(IDecoratorInterface newDecorator) {
        this.textDecorators.add(newDecorator);
    }

    public void removeDecorator(IDecoratorInterface toRemove) {
        this.textDecorators.remove(toRemove);
    }

    public boolean contains(IDecoratorInterface element) {
        return this.textDecorators.contains(element);
    }

    @Override
    public void paint(Graphics graphics, ComponentFigure fig) {
        if (fig.getJrElement() instanceof JRDesignElement) {
            Rectangle r = fig.getBounds();
            Graphics2D g = ComponentFigure.getG2D(graphics);
            if (g != null) {
                HashMap<AbstractPainter.Location, Integer> textMap = new HashMap<AbstractPainter.Location, Integer>();
                Stroke oldStroke = g.getStroke();
                Color oldColor = g.getColor();
                Font oldFont = g.getFont();
                g.setStroke(J2DUtils.getInvertedZoomedStroke(oldStroke, graphics.getAbsoluteScale()));
                boolean leftUpperCorner = false;
                boolean rightLowerCorner = false;
                for (IDecoratorInterface decorator : this.textDecorators) {
                    ArrayList<AbstractPainter> texts = decorator.getDecoratorPainter(fig);
                    for (AbstractPainter text : texts) {
                        Integer strWidth;
                        Point elementSize = text.getElementSize(g);
                        if (elementSize.x == 0 || elementSize.y == 0) continue;
                        if (!textMap.containsKey((Object)text.getLocation())) {
                            textMap.put(text.getLocation(), 0);
                            strWidth = 0;
                        } else {
                            strWidth = (Integer)textMap.get((Object)text.getLocation());
                        }
                        switch (text.getLocation()) {
                            case TopLeft: {
                                text.paint(g, r.x + strWidth + 4, r.y + 11);
                                strWidth = strWidth + text.getElementSize((Graphics2D)g).x;
                                leftUpperCorner = true;
                                break;
                            }
                            case TopRight: {
                                strWidth = strWidth + text.getElementSize((Graphics2D)g).x;
                                text.paint(g, r.x + r.width - strWidth - 6, r.y + 11);
                                break;
                            }
                            case BottomLeft: {
                                text.paint(g, r.x + strWidth + 4, r.y + r.height - text.getElementSize((Graphics2D)g).y);
                                strWidth = strWidth + text.getElementSize((Graphics2D)g).x;
                                break;
                            }
                            case BottomRight: {
                                strWidth = strWidth + text.getElementSize((Graphics2D)g).x;
                                text.paint(g, r.x + r.width - strWidth - 6, r.y + r.height - text.getElementSize((Graphics2D)g).y);
                                rightLowerCorner = true;
                            }
                        }
                        strWidth = strWidth + (g.getFontMetrics().stringWidth(" ") + 1);
                        textMap.put(text.getLocation(), strWidth);
                    }
                }
                if (leftUpperCorner) {
                    this.drawStart(g, r);
                }
                if (rightLowerCorner) {
                    this.drawEnd(g, r);
                }
                g.setStroke(oldStroke);
                g.setColor(oldColor);
                g.setFont(oldFont);
            }
        }
    }

    private void drawEnd(Graphics2D gr, Rectangle r) {
        gr.drawImage(endImageAwt.getImage(), r.x + r.width - endImageAwt.getIconWidth() - 2, r.y + r.height - endImageAwt.getIconHeight() - 2, null);
    }

    private void drawStart(Graphics2D gr, Rectangle r) {
        gr.drawImage(startImageAwt.getImage(), r.x, r.y, null);
    }
}

