/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.error;

import com.jaspersoft.studio.editor.gef.decorator.IDecorator;
import com.jaspersoft.studio.editor.gef.decorator.error.RoundedPolygon;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class ErrorDecorator
implements IDecorator {
    private static Color JSS_WARNING_BORDER_COLOR = new Color(255, 0, 0, 128);
    private static Color JSS_ERROR_BORDER_COLOR = new Color(255, 0, 0);
    private static float JSS_WARNING_BORDER_SIZE = 1.0f;
    private String errorTooltip;
    private List<ValidationError> errorMessages;
    private boolean hasErrors = false;

    @Override
    public void paint(Graphics graphics, ComponentFigure fig) {
        if (fig.getJrElement() instanceof JRDesignElement) {
            Rectangle r = fig.getBounds();
            Graphics2D g = ComponentFigure.getG2D(graphics);
            if (g != null) {
                Stroke oldStroke = g.getStroke();
                Color oldColor = g.getColor();
                if (this.hasErrors) {
                    g.setColor(JSS_ERROR_BORDER_COLOR);
                } else {
                    g.setColor(JSS_WARNING_BORDER_COLOR);
                }
                g.setStroke(new BasicStroke(JSS_WARNING_BORDER_SIZE));
                PrecisionRectangle tempRect = new PrecisionRectangle();
                tempRect.setBounds(fig.getBounds());
                if (JSS_WARNING_BORDER_SIZE % 2.0f == 1.0f) {
                    tempRect.width = tempRect.width - 1;
                    tempRect.height = tempRect.height - 1;
                }
                tempRect.width -= (int)Math.ceil(JSS_WARNING_BORDER_SIZE);
                tempRect.height -= (int)Math.ceil(JSS_WARNING_BORDER_SIZE);
                tempRect.shrink((double)JSS_WARNING_BORDER_SIZE, (double)JSS_WARNING_BORDER_SIZE);
                g.setStroke(new BasicStroke(JSS_WARNING_BORDER_SIZE));
                g.drawRect(tempRect.x, tempRect.y, tempRect.width, tempRect.height);
                if (this.hasErrors) {
                    graphics.drawImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"), r.x + r.width - 10, r.y + 1);
                } else {
                    RoundedPolygon.paintComplexWarning(r.x + r.width - 5, r.y - 2, 6, 12, JSS_WARNING_BORDER_SIZE, g);
                }
                if (this.errorTooltip != null) {
                    if (this.hasErrors) {
                        fig.setToolTip((IFigure)new Label(this.errorTooltip, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR")));
                    } else {
                        fig.setToolTip((IFigure)new Label(this.errorTooltip, ResourceManager.getPluginImage((String)"com.jaspersoft.studio", (String)"icons/resources/warning2.png")));
                    }
                }
                g.setStroke(oldStroke);
                g.setColor(oldColor);
            }
        }
    }

    public void setBorderColor(Color newColor) {
        JSS_WARNING_BORDER_COLOR = newColor;
    }

    public void setBorderSize(float newSize) {
        JSS_WARNING_BORDER_SIZE = newSize;
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    public void setErrorMessages(List<ValidationError> errorMessages) {
        this.errorMessages = errorMessages;
        String msg = "";
        String del = "";
        for (ValidationError error : errorMessages) {
            msg = String.valueOf(msg) + del + error.getMessage();
            del = "\n";
            if (error.isWarning()) continue;
            this.hasErrors = true;
        }
        this.setErrorTooltip(msg);
    }

    public List<ValidationError> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorTooltip(String message) {
        this.errorTooltip = message;
    }
}

