/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.error;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;

public class RoundedPolygon {
    private static Color startColor = new Color(254, 234, 88);
    private static Color endColor = new Color(230, 164, 38);
    private static Color borderColor = Color.orange;
    private static Font messageFont = new Font("SansSerif", 0, 9);

    public static void setStartColor(Color newColor) {
        startColor = newColor;
    }

    public static void setEndColor(Color newColor) {
        endColor = newColor;
    }

    public static void setBorderColor(Color newColor) {
        borderColor = newColor;
    }

    public static void setFont(Font newFont) {
        messageFont = newFont;
    }

    public static GeneralPath getRoundedGeneralPath(Polygon polygon) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        int i = 0;
        while (i < polygon.npoints) {
            l.add(new int[]{polygon.xpoints[i], polygon.ypoints[i]});
            ++i;
        }
        return RoundedPolygon.getRoundedGeneralPath(l);
    }

    public static GeneralPath getRoundedGeneralPath(List<int[]> l) {
        ArrayList<Point> list = new ArrayList<Point>();
        for (int[] point : l) {
            list.add(new Point(point[0], point[1]));
        }
        return RoundedPolygon.getRoundedGeneralPathFromPoints(list);
    }

    public static GeneralPath getRoundedGeneralPathFromPoints(List<Point> l) {
        l.add(l.get(0));
        l.add(l.get(1));
        GeneralPath p = new GeneralPath();
        p.moveTo(l.get((int)0).x, l.get((int)0).y);
        int pointIndex = 1;
        while (pointIndex < l.size() - 1) {
            Point p1 = l.get(pointIndex - 1);
            Point p2 = l.get(pointIndex);
            Point p3 = l.get(pointIndex + 1);
            Point mPoint = RoundedPolygon.calculatePoint(p1, p2);
            p.lineTo(mPoint.x, mPoint.y);
            mPoint = RoundedPolygon.calculatePoint(p3, p2);
            p.curveTo(p2.x, p2.y, p2.x, p2.y, mPoint.x, mPoint.y);
            ++pointIndex;
        }
        return p;
    }

    private static Point calculatePoint(Point p1, Point p2) {
        float arcSize = 10.0f;
        double d1 = Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
        double per = (double)arcSize / d1;
        double d_x = (double)(p1.x - p2.x) * per;
        double d_y = (double)(p1.y - p2.y) * per;
        int xx = (int)((double)p2.x + d_x);
        int yy = (int)((double)p2.y + d_y);
        return new Point(xx, yy);
    }

    public static GeneralPath getWarningPath(float x, float y, float width, float height) {
        GeneralPath p0 = new GeneralPath();
        double border = 2.0;
        double sin = Math.sin(Math.toRadians(60.0)) * border;
        double cos = Math.cos(Math.toRadians(60.0)) * border;
        float x_left_corner = x - width;
        float y_corners = y + height;
        float x_right_corner = x + width;
        p0.moveTo((double)x - cos, (double)y + sin);
        p0.lineTo((double)x_left_corner + cos, (double)y_corners - sin);
        p0.curveTo((double)x_left_corner + cos, (double)y_corners - sin, (double)x_left_corner, (double)y_corners, (double)x_left_corner + border, (double)y_corners);
        p0.lineTo((double)x_right_corner - border, (double)y_corners);
        p0.curveTo((double)x_right_corner - border, (double)y_corners, (double)x_right_corner, (double)y_corners, (double)x_right_corner - cos, (double)y_corners - sin);
        p0.lineTo((double)x + cos, (double)y + sin);
        p0.curveTo((double)x + cos, (double)y + sin, (double)x, (double)y, (double)x - cos, (double)y + sin);
        p0.closePath();
        return p0;
    }

    public static void paintPath(GeneralPath p0, Graphics2D g, Color fillColor) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Object oldRendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Paint oldGradient = g.getPaint();
        Font oldFont = g.getFont();
        g.setColor(fillColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(p0);
        g.setFont(oldFont);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRendering);
        g.setPaint(oldGradient);
    }

    public static void paintGradientPath(GeneralPath p0, Graphics2D g, GradientPaint gp) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Object oldRendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Paint oldGradient = g.getPaint();
        Font oldFont = g.getFont();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(gp);
        g.fill(p0);
        g.setFont(oldFont);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRendering);
        g.setPaint(oldGradient);
    }

    public static void paintComplexWarning(int x, int y, int width, int height, float stroke, Graphics2D g) {
        Shape oldClip = g.getClip();
        g.setClip(null);
        GeneralPath p0 = RoundedPolygon.getWarningPath(x + 1, y + 1, width, height);
        RoundedPolygon.paintPath(p0, g, new Color(0, 0, 0, 128));
        GradientPaint gp = new GradientPaint(x + width, y + height, new Color(207, 140, 32), x, y, new Color(254, 222, 55));
        p0 = RoundedPolygon.getWarningPath(x, y, width, height);
        RoundedPolygon.paintGradientPath(p0, g, gp);
        RoundedPolygon.paintWarningIcon(x, new Float(y + 1).floatValue(), new Float((double)width - 0.7).floatValue(), new Float((double)height - 1.5).floatValue(), 0.0f, g);
        g.setClip(oldClip);
    }

    public static void paintWarningPath(int x, int y, float stroke, GeneralPath p0, Graphics2D g) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Object oldRendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Paint oldGradient = g.getPaint();
        Font oldFont = g.getFont();
        g.setStroke(new BasicStroke(stroke));
        g.setColor(borderColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gp = new GradientPaint(x, y, startColor, x, y + p0.getBounds().height, endColor);
        g.draw(p0);
        g.setPaint(gp);
        g.fill(p0);
        g.setColor(Color.black);
        g.setFont(messageFont);
        int fontWidth = g.getFontMetrics().stringWidth("!");
        float x_middle = new Float((double)(x - fontWidth / 2) - 0.3).floatValue();
        g.drawString("!", x_middle, (float)y + stroke + (float)messageFont.getSize());
        g.setFont(oldFont);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRendering);
        g.setPaint(oldGradient);
    }

    public static void paintWarningIcon(float x, float y, float width, float height, float stroke, Graphics2D g) {
        GeneralPath p0 = new GeneralPath();
        double border = 2.0;
        double sin = Math.sin(Math.toRadians(60.0)) * border;
        double cos = Math.cos(Math.toRadians(60.0)) * border;
        float x_left_corner = x - width;
        float y_corners = y + height;
        float x_right_corner = x + width;
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        Object oldRendering = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Paint oldGradient = g.getPaint();
        Font oldFont = g.getFont();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(stroke));
        g.setColor(borderColor);
        p0.moveTo((double)x - cos, (double)y + sin);
        p0.lineTo((double)x_left_corner + cos, (double)y_corners - sin);
        p0.curveTo((double)x_left_corner + cos, (double)y_corners - sin, (double)x_left_corner, (double)y_corners, (double)x_left_corner + border, (double)y_corners);
        p0.lineTo((double)x_right_corner - border, (double)y_corners);
        p0.curveTo((double)x_right_corner - border, (double)y_corners, (double)x_right_corner, (double)y_corners, (double)x_right_corner - cos, (double)y_corners - sin);
        p0.lineTo((double)x + cos, (double)y + sin);
        p0.curveTo((double)x + cos, (double)y + sin, (double)x, (double)y, (double)x - cos, (double)y + sin);
        p0.closePath();
        g.draw(p0);
        GradientPaint gp = new GradientPaint(x, y, startColor, x, y_corners, endColor);
        g.setPaint(gp);
        g.fill(p0);
        g.setColor(Color.black);
        g.setFont(messageFont);
        int fontWidth = g.getFontMetrics().stringWidth("!");
        float x_middle = new Float((double)(x - (float)(fontWidth / 2)) - 0.3).floatValue();
        g.drawString("!", x_middle, y + stroke + (float)messageFont.getSize());
        g.setFont(oldFont);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRendering);
        g.setPaint(oldGradient);
    }
}

