/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.spreadsheet;

import com.jaspersoft.studio.editor.gef.decorator.IDecorator;
import com.jaspersoft.studio.editor.gef.decorator.chainable.AbstractPainter;
import com.jaspersoft.studio.editor.gef.decorator.chainable.IDecoratorInterface;
import com.jaspersoft.studio.editor.gef.decorator.image.ImageLocation;
import com.jaspersoft.studio.editor.gef.figures.AHandleBoundsFigure;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.spreadsheet.SpreadsheetLayout;
import com.jaspersoft.studio.model.MGraphicElement;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;

public class SpreadsheetDecorator
implements IDecorator,
IDecoratorInterface {
    private ImageLocation bindedImage = new ImageLocation(AbstractPainter.Location.BottomLeft, "icons/resources/bindedElementsDecorator.png");

    @Override
    public void paint(Graphics graphics, ComponentFigure fig) {
        if (fig.getJrElement() instanceof JRDesignElement) {
            Rectangle r = fig.getBounds();
            Graphics2D g = ComponentFigure.getG2D(graphics);
            if (g != null) {
                Stroke oldStroke = g.getStroke();
                g.setStroke(J2DUtils.getInvertedZoomedStroke(oldStroke, graphics.getAbsoluteScale()));
                JRPropertiesMap v = fig.getJrElement().getPropertiesMap();
                if (v.containsProperty("com.jaspersoft.studio.spreadsheet.connectionID") && fig instanceof AHandleBoundsFigure) {
                    MGraphicElement model = ((AHandleBoundsFigure)fig).getModel();
                    JRPropertiesMap parentMap = LayoutManager.getPropertyMap(model.getParent());
                    String ssName = SpreadsheetLayout.class.getName();
                    if (parentMap != null && ssName.equals(parentMap.getProperty("com.jaspersoft.studio.layout"))) {
                        this.bindedImage.paint(g, r.x + 4, r.y + r.height - this.bindedImage.getElementSize((Graphics2D)g).y);
                    }
                }
            }
        }
    }

    @Override
    public ArrayList<AbstractPainter> getDecoratorPainter(ComponentFigure fig) {
        JRPropertiesMap mapProperties = fig.getJrElement().getPropertiesMap();
        ArrayList<AbstractPainter> result = new ArrayList<AbstractPainter>();
        if (mapProperties.containsProperty("com.jaspersoft.studio.spreadsheet.connectionID") && fig instanceof AHandleBoundsFigure) {
            MGraphicElement model = ((AHandleBoundsFigure)fig).getModel();
            JRPropertiesMap parentMap = LayoutManager.getPropertyMap(model.getParent());
            String ssName = SpreadsheetLayout.class.getName();
            if (parentMap != null && ssName.equals(parentMap.getProperty("com.jaspersoft.studio.layout"))) {
                result.add(this.bindedImage);
            }
        }
        return result;
    }
}

