/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.decorator.xls;

import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.snap.ACheckResourcePrefAction;
import com.jaspersoft.studio.editor.action.xls.XLSAction;
import com.jaspersoft.studio.editor.action.xls.XLSActionList;
import com.jaspersoft.studio.editor.action.xls.XLSPathDataAction;
import com.jaspersoft.studio.editor.gef.decorator.chainable.ChainableDecorator;
import com.jaspersoft.studio.editor.gef.decorator.chainable.ChainableElementDecorator;
import com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSBreakAction;
import com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction;
import com.jaspersoft.studio.editor.gef.decorator.xls.XLSDecorator;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;

public class XLSElementDecorator
extends ChainableElementDecorator {
    private Stroke dashed = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
    private Stroke solid = new BasicStroke(2.0f, 0, 2);
    private Color red = new Color(255, 0, 0, 128);
    private Color blue = new Color(0, 0, 255, 128);
    private XLSDecorator decorator = new XLSDecorator();
    private List<String> actionIDs;

    @Override
    public void setupFigure(ComponentFigure fig, FigureEditPart editPart) {
        super.setupFigure(fig, editPart);
        ChainableDecorator dec = this.getDecorator(fig);
        dec.removeDecorator(this.decorator);
        if (editPart.getjConfig().getPropertyBooleanDef("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction", false).booleanValue()) {
            dec.addDecorator(this.decorator);
        }
    }

    private void registerFit(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        CustomSelectionAction action = new XLSAction(part, XLSAction.FIT_ROW_ID, "true", Messages.XLSElementDecorator_fitRowAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FIT_COL_ID, "true", Messages.XLSElementDecorator_fitColAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSActionList(part, "XLS_Fit_None", new String[]{XLSAction.FIT_ROW_ID, XLSAction.FIT_COL_ID}, new String[2], Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void registerAutoFilter(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        XLSAction action = new XLSAction(part, XLSAction.AUTOFILTER_ID.concat(XLSDecorator.START), XLSAction.AUTOFILTER_ID, XLSDecorator.START, Messages.XLSElementDecorator_startAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.AUTOFILTER_ID.concat(XLSDecorator.END), XLSAction.AUTOFILTER_ID, XLSDecorator.END, Messages.XLSElementDecorator_endAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.AUTOFILTER_ID.concat("none"), XLSAction.AUTOFILTER_ID, null, Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void registerBreak(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        CustomSelectionAction action = new XLSAction(part, XLSAction.BREAK_AFTER_ROW_ID, XLSAction.BREAK_AFTER_ROW_ID, "true", Messages.XLSElementDecorator_breakAfterAction, new String[]{XLSAction.BREAK_BEFORE_ROW_ID});
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.BREAK_BEFORE_ROW_ID, XLSAction.BREAK_BEFORE_ROW_ID, "true", Messages.XLSElementDecorator_breakBeforeAction, new String[]{XLSAction.BREAK_AFTER_ROW_ID});
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSActionList(part, "XSL_Break_None", new String[]{XLSAction.BREAK_AFTER_ROW_ID, XLSAction.BREAK_BEFORE_ROW_ID}, new String[2], Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void registerCellProperties(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        CustomSelectionAction action = new XLSAction(part, XLSAction.CELL_HIDDEN_ID, XLSAction.CELL_HIDDEN_ID, "true", Messages.XLSElementDecorator_hiddenCellAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.CELL_LOCKED_ID, XLSAction.CELL_LOCKED_ID, "true", Messages.XLSElementDecorator_lockCellAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSActionList(part, "XSL_Cell_None", new String[]{XLSAction.CELL_HIDDEN_ID, XLSAction.CELL_LOCKED_ID}, new String[2], Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    private void registerFreezeProperties(ActionRegistry registry, IWorkbenchPart part, List<String> selectionActions) {
        XLSAction action = new XLSAction(part, XLSAction.FREEZE_COL_ID.concat("Left"), XLSAction.FREEZE_COL_ID, "Left", Messages.XLSElementDecorator_leftAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FREEZE_COL_ID.concat("Right"), XLSAction.FREEZE_COL_ID, "Right", Messages.XLSElementDecorator_rightAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FREEZE_COL_ID.concat("None"), XLSAction.FREEZE_COL_ID, null, Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FREEZE_ROW_ID.concat("Top"), XLSAction.FREEZE_ROW_ID, "Top", Messages.XLSElementDecorator_topAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FREEZE_ROW_ID.concat("Bottom"), XLSAction.FREEZE_ROW_ID, "Bottom", Messages.XLSElementDecorator_bottomAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new XLSAction(part, XLSAction.FREEZE_ROW_ID.concat("None"), XLSAction.FREEZE_ROW_ID, null, Messages.XLSElementDecorator_nonAction);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    @Override
    public void registerActions(ActionRegistry registry, List<String> selectionActions, IWorkbenchPart part) {
        this.registerFit(registry, part, selectionActions);
        this.registerAutoFilter(registry, part, selectionActions);
        this.registerBreak(registry, part, selectionActions);
        this.registerCellProperties(registry, part, selectionActions);
        this.registerFreezeProperties(registry, part, selectionActions);
        XLSPathDataAction action = new XLSPathDataAction(part);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    @Override
    public void registerActions(ActionRegistry registry, List<String> selectionActions, GraphicalViewer gviewer, AbstractVisualEditor part) {
        gviewer.setProperty("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction", (Object)true);
        ACheckResourcePrefAction action = new ShowXLSTagsAction(gviewer, part.getJrContext());
        registry.registerAction((IAction)action);
        action = new ShowXLSBreakAction(gviewer, part.getJrContext());
        registry.registerAction((IAction)action);
        this.registerActions(registry, selectionActions, (IWorkbenchPart)part);
    }

    @Override
    public void fillContextMenu(ActionRegistry registry, IMenuManager menu, IStructuredSelection sel) {
        MenuManager submenu = new MenuManager(Messages.XLSElementDecorator_xlsTagsMenu);
        MenuManager fitMenu = new MenuManager(Messages.XLSElementDecorator_fitMenu);
        MenuManager autoFilterMenu = new MenuManager(Messages.XLSElementDecorator_autoFilterMenu);
        MenuManager breakMenu = new MenuManager(Messages.XLSElementDecorator_breakMenu);
        MenuManager freezeMenu = new MenuManager(Messages.XLSElementDecorator_freezeMenu);
        MenuManager freezeRowMenu = new MenuManager(Messages.XLSElementDecorator_rowsMenu);
        MenuManager freezeColMenu = new MenuManager(Messages.XLSElementDecorator_columnsMenu);
        MenuManager propertiesMenu = new MenuManager(Messages.XLSElementDecorator_cellPropertiesMenu);
        submenu.add((IContributionItem)fitMenu);
        submenu.add((IContributionItem)autoFilterMenu);
        submenu.add((IContributionItem)breakMenu);
        submenu.add((IContributionItem)propertiesMenu);
        freezeMenu.add((IContributionItem)freezeRowMenu);
        freezeMenu.add((IContributionItem)freezeColMenu);
        submenu.add((IContributionItem)freezeMenu);
        IAction action = registry.getAction((Object)XLSAction.FIT_ROW_ID);
        fitMenu.add(action);
        action = registry.getAction((Object)XLSAction.FIT_COL_ID);
        fitMenu.add(action);
        action = registry.getAction((Object)"XLS_Fit_None");
        fitMenu.add(action);
        action = registry.getAction((Object)XLSAction.AUTOFILTER_ID.concat(XLSDecorator.START));
        autoFilterMenu.add(action);
        action = registry.getAction((Object)XLSAction.AUTOFILTER_ID.concat(XLSDecorator.END));
        autoFilterMenu.add(action);
        action = registry.getAction((Object)XLSAction.AUTOFILTER_ID.concat("none"));
        autoFilterMenu.add(action);
        action = registry.getAction((Object)XLSAction.BREAK_BEFORE_ROW_ID);
        breakMenu.add(action);
        action = registry.getAction((Object)XLSAction.BREAK_AFTER_ROW_ID);
        breakMenu.add(action);
        action = registry.getAction((Object)"XSL_Break_None");
        breakMenu.add(action);
        action = registry.getAction((Object)XLSAction.CELL_HIDDEN_ID);
        propertiesMenu.add(action);
        action = registry.getAction((Object)XLSAction.CELL_LOCKED_ID);
        propertiesMenu.add(action);
        action = registry.getAction((Object)"XSL_Cell_None");
        propertiesMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_ROW_ID.concat("Top"));
        freezeRowMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_ROW_ID.concat("Bottom"));
        freezeRowMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_ROW_ID.concat("None"));
        freezeRowMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_COL_ID.concat("Left"));
        freezeColMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_COL_ID.concat("Right"));
        freezeColMenu.add(action);
        action = registry.getAction((Object)XLSAction.FREEZE_COL_ID.concat("None"));
        freezeColMenu.add(action);
        action = registry.getAction((Object)"net.sf.jasperreports.export.xls.column.name");
        submenu.add(action);
        menu.add((IContributionItem)submenu);
    }

    @Override
    public void buildContextMenu(ActionRegistry registry, EditPartViewer viewer, IMenuManager menu) {
        EditPart ep;
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        if (sel.getFirstElement() instanceof EditPart && !((ep = (EditPart)sel.getFirstElement()).getModel() instanceof MGraphicElement)) {
            return;
        }
        this.fillContextMenu(registry, menu, sel);
    }

    @Override
    public RetargetAction[] buildMenuActions() {
        return new RetargetAction[]{new RetargetAction("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction", Messages.XLSElementDecorator_showXLSTagsLabel, 2), new RetargetAction("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSBreakAction", Messages.ShowXLSBreakAction_name, 2)};
    }

    @Override
    public void contribute2Menu(ActionRegistry registry, MenuManager menuManager) {
        menuManager.add(registry.getAction((Object)"com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction"));
        menuManager.add(registry.getAction((Object)"com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSBreakAction"));
    }

    @Override
    public List<String> getActionIDs() {
        if (this.actionIDs == null) {
            this.actionIDs = new ArrayList<String>(2);
            this.actionIDs.add("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSTagsAction");
            this.actionIDs.add("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSBreakAction");
        }
        return this.actionIDs;
    }

    private ANode getPageRoot(JasperReportsConfiguration jConfig) {
        JasperDesign jd = jConfig.getJasperDesign();
        JRBand[] jRBandArray = jd.getAllBands();
        int n = jRBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRBand band = jRBandArray[n2];
            ANode node = SelectionHelper.getNode(band);
            if (node != null) {
                return node.getParent();
            }
            ++n2;
        }
        return null;
    }

    private void collectChildren(INode currentNode, List<Rectangle> positions) {
        if (currentNode != null) {
            for (INode child : currentNode.getChildren()) {
                if (child instanceof IGraphicalPropertiesHandler) {
                    IGraphicalPropertiesHandler handler = (IGraphicalPropertiesHandler)((Object)child);
                    Rectangle bounds = handler.getAbsoluteBounds();
                    if (child.getValue() instanceof JRDesignComponentElement) {
                        JRDesignComponentElement compElement = (JRDesignComponentElement)child.getValue();
                        if (compElement.getComponent() instanceof StandardTable) {
                            StandardTable table = (StandardTable)compElement.getComponent();
                            int currentColumnWidth = 0;
                            for (BaseColumn column : table.getColumns()) {
                                positions.add(new Rectangle(bounds.x + currentColumnWidth, bounds.y, column.getWidth().intValue(), bounds.height));
                                currentColumnWidth += column.getWidth().intValue();
                            }
                        }
                    } else {
                        positions.add(new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height));
                        positions.add(new Rectangle(bounds.x + bounds.width, bounds.y, bounds.width, bounds.height));
                    }
                }
                this.collectChildren(child, positions);
            }
        }
    }

    @Override
    public void paintGlobal(Graphics g, IFigure figure, JasperReportsConfiguration jConfig) {
        if (jConfig.getPropertyBooleanDef("com.jaspersoft.studio.editor.gef.decorator.xls.ShowXLSBreakAction", false).booleanValue()) {
            ArrayList<Rectangle> positions = new ArrayList<Rectangle>();
            ANode root = this.getPageRoot(jConfig);
            this.collectChildren(root, positions);
            if (!positions.isEmpty()) {
                JasperDesign jd = jConfig.getJasperDesign();
                int dxOffset = 10;
                int dyOffset = 10;
                int minX = 0;
                int minY = 0;
                int maxX = jConfig.getJasperDesign().getPageWidth();
                int maxY = jd.getTopMargin() + jd.getBottomMargin();
                JRBand[] jRBandArray = jd.getAllBands();
                int n = jRBandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JRBand band = jRBandArray[n2];
                    if (band != null) {
                        maxY += band.getHeight();
                    }
                    ++n2;
                }
                for (Rectangle position : positions) {
                    if (position.x < minX) {
                        minX = position.x;
                    }
                    if (position.x > maxX) {
                        maxX = position.x;
                    }
                    if (position.y < minY) {
                        minY = position.y;
                    }
                    if (position.y <= maxY) continue;
                    maxY = position.y;
                }
                positions.sort(new Comparator<Rectangle>(){

                    @Override
                    public int compare(Rectangle o1, Rectangle o2) {
                        return o1.x - o2.x;
                    }
                });
                ArrayList aggregatedPositions = new ArrayList();
                Rectangle previousValue = null;
                for (Rectangle position : positions) {
                    List<Rectangle> subList;
                    if (previousValue == null || previousValue.x != position.x) {
                        subList = new ArrayList<Rectangle>();
                        subList.add(position);
                        aggregatedPositions.add(subList);
                    } else {
                        subList = (List)aggregatedPositions.get(aggregatedPositions.size() - 1);
                        subList.add(position);
                    }
                    previousValue = position;
                }
                Graphics2D g2d = ((J2DGraphics)g).getGraphics2D();
                g2d.drawRect(minX + dxOffset, minY + dyOffset, maxX - minX, maxY - minY);
                g2d.setColor(this.red);
                for (List list : aggregatedPositions) {
                    list.sort(new Comparator<Rectangle>(){

                        @Override
                        public int compare(Rectangle o1, Rectangle o2) {
                            return o1.y - o2.y;
                        }
                    });
                    int startY = minY + dyOffset;
                    int currentIndex = 0;
                    for (Rectangle position : list) {
                        g2d.setStroke(this.solid);
                        int endY = startY + position.y;
                        if (currentIndex - 1 >= 0) {
                            Rectangle previusLine = (Rectangle)list.get(currentIndex - 1);
                            endY -= previusLine.y + previusLine.height;
                        }
                        g2d.drawLine(position.x + dxOffset, startY, position.x + dxOffset, endY);
                        startY = endY;
                        g2d.setStroke(this.dashed);
                        g2d.drawLine(position.x + dxOffset, startY, position.x + dxOffset, endY += position.height);
                        startY = endY;
                        if (++currentIndex != list.size()) continue;
                        g2d.setStroke(this.solid);
                        g2d.drawLine(position.x + dxOffset, startY, position.x + dxOffset, maxY + dyOffset);
                    }
                    if (g2d.getColor() == this.red) {
                        g2d.setColor(this.blue);
                        continue;
                    }
                    g2d.setColor(this.red);
                }
            }
        }
    }
}

