/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.figures.GridPainter;
import com.jaspersoft.studio.editor.gef.parts.JSSScalableFreeformRootEditPart;
import com.jaspersoft.studio.editor.gef.parts.PageEditPart;
import com.jaspersoft.studio.editor.java2d.JSSScrollingGraphicalViewer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;

public abstract class APageFigure
extends FreeformLayeredPane
implements HandleBounds {
    protected Color pageBackground = SWTResourceManager.getColor((int)255, (int)255, (int)255);
    protected boolean viewMargins = true;
    public static final Insets PAGE_BORDER = new Insets(10, 10, 10, 10);
    protected Point origin = new Point();
    protected GridPainter grid = new GridPainter();
    protected PageEditPart page;
    private ZoomManager zoomManager = null;
    private Viewport viewPort = null;
    protected int dx = 0;
    protected int dy = 0;

    public APageFigure(boolean viewMargins, PageEditPart page) {
        this.viewMargins = viewMargins;
        this.page = page;
    }

    public void setPageBackground(Color pageBackground) {
        this.pageBackground = pageBackground;
    }

    public void setViewMargins(boolean viewMargins) {
        this.viewMargins = viewMargins;
    }

    public void paintFigure(Graphics g) {
        if (this.viewMargins) {
            Rectangle clientArea = this.getClientArea();
            clientArea.x -= this.dx;
            clientArea.y -= this.dy;
            int pageWidth = this.getSize().width;
            int pageHeight = this.getSize().height;
            Rectangle rectangle = new Rectangle(clientArea.x, clientArea.y, pageWidth, pageHeight);
            g.setBackgroundColor(this.pageBackground);
            g.fillRectangle(rectangle);
            this.setGridSize(rectangle, g);
        }
        if (this.getBorder() != null) {
            this.getBorder().paint((IFigure)this, g, NO_INSETS);
        }
    }

    protected void primTranslate(int dx, int dy) {
        this.dx += dx;
        this.dy += dy;
        super.primTranslate(dx, dy);
    }

    protected void setGridSize(Rectangle size, Graphics graphics) {
        if (this.grid.isVisible()) {
            this.grid.setBounds(size);
            this.grid.paintGrid(graphics, (IFigure)this);
        }
    }

    protected void paintBorder(Graphics graphics) {
    }

    public Rectangle getHandleBounds() {
        Rectangle clientArea = this.getClientArea();
        clientArea.x -= this.dx;
        clientArea.y -= this.dy;
        int pageWidth = this.getSize().width;
        int pageHeight = this.getSize().height;
        Insets insets = this.getInsets();
        return new Rectangle(clientArea.x - insets.right, clientArea.y - insets.top, pageWidth + insets.left + insets.right, pageHeight + insets.top + insets.bottom);
    }

    public Rectangle getFreeformExtent() {
        Rectangle freeformExtent = super.getFreeformExtent();
        freeformExtent.height += APageFigure.PAGE_BORDER.bottom + 80;
        return freeformExtent;
    }

    public GridPainter getGrid() {
        return this.grid;
    }

    protected Viewport getViewPort() {
        if (this.viewPort == null) {
            IFigure figure = this.getParent();
            while (figure != null && !(figure instanceof Viewport)) {
                figure = figure.getParent();
            }
            if (figure != null) {
                this.viewPort = (Viewport)figure;
            }
        }
        return this.viewPort;
    }

    protected double getZoom() {
        if (this.zoomManager == null) {
            EditPartViewer viewer = this.page.getViewer();
            this.zoomManager = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
            if (this.zoomManager == null) {
                this.zoomManager = ((JSSScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            }
        }
        return this.zoomManager != null ? this.zoomManager.getZoom() : 1.0;
    }

    public boolean isFigureVisible(IFigure figure) {
        boolean paintOnlyVisible = ((JSSScrollingGraphicalViewer)this.page.getViewer()).isPaintOnlyVisibleElements();
        if (!paintOnlyVisible) {
            return true;
        }
        if (figure == null) {
            return false;
        }
        double zoom = this.getZoom();
        Rectangle visibleArea = this.getViewPort().getClientArea();
        Rectangle bounds = figure.getBounds();
        int figureStartX = (int)Math.round((double)bounds.x * zoom);
        int figureStartY = (int)Math.round((double)bounds.y * zoom);
        int figureEndX = (int)Math.round((double)bounds.width * zoom);
        int fiugreEndY = (int)Math.round((double)bounds.height * zoom);
        Rectangle figureArea = new Rectangle(figureStartX, figureStartY, figureEndX, fiugreEndY);
        boolean result = figureArea.intersects(visibleArea);
        return result;
    }
}

