/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.decorator.pdf.PDFDecorator;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.texture.EmptyTexture;
import com.jaspersoft.studio.editor.gef.util.FigureTextWriter;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.band.MBand;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;

public class BandFigure
extends RectangleFigure {
    public Color marginsColor = SWTResourceManager.getColor((int)170, (int)168, (int)255);
    private MBand bandModel;
    private int columnNumber = 1;
    private int columnSpacing = 0;
    private int columnWidth = 0;
    private int marginLeft = 0;
    private int marginRight = 0;
    private boolean drawColumn = false;
    private String bandText;
    private String hiddenText;
    private static TexturePaint restrictedAreaTexture = null;
    private FigureTextWriter twriter = new FigureTextWriter();
    private TexturePaint tp;

    public Color getMarginsColor() {
        return this.marginsColor;
    }

    public void setMarginsColor(Color marginsColor) {
        this.marginsColor = marginsColor;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int columnSpacing) {
        this.columnSpacing = columnSpacing;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public BandFigure(boolean drawColumn, MBand model) {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setOpaque(false);
        this.drawColumn = drawColumn;
        this.bandModel = model;
        this.createTexture();
    }

    private static TexturePaint getRestrictedAreaTexture() {
        if (restrictedAreaTexture == null) {
            Image img2 = new ImageIcon(PDFDecorator.class.getResource("/icons/resources/restricted_area.png")).getImage();
            BufferedImage img = new BufferedImage(14, 14, 2);
            img.getGraphics().drawImage(img2, 0, 0, null);
            restrictedAreaTexture = new TexturePaint(img, new java.awt.Rectangle(0, 0, 14, 14));
        }
        return restrictedAreaTexture;
    }

    public void paint(Graphics graphics) {
        Rectangle b = this.getBounds();
        graphics.setForegroundColor(this.marginsColor);
        graphics.setBackgroundColor(this.marginsColor);
        graphics.setAlpha(128);
        Graphics2D g = ComponentFigure.getG2D(graphics);
        if (g != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(J2DUtils.getInvertedZoomedStroke(oldStroke, graphics.getAbsoluteScale()));
            g.drawLine(b.x, b.y, b.x + b.width, b.y);
            g.drawLine(b.x, b.y + b.height - 1, b.x + b.width, b.y + b.height - 1);
            if (!this.bandModel.isVisible()) {
                g.drawLine(b.x, b.y, b.x + b.width, b.y + b.height);
                g.drawLine(b.x + b.width, b.y, b.x, b.y + b.height);
                this.twriter.setText(this.hiddenText);
            } else {
                this.twriter.setText(this.bandText);
            }
            this.twriter.painText(g, (IFigure)this);
            if (this.drawColumn) {
                int x = this.marginLeft + ReportPageFigure.PAGE_BORDER.left;
                int i = 0;
                while (i < this.columnNumber) {
                    if (i > 0) {
                        g.drawLine(x, b.y, x, b.y + b.height + 1);
                        Paint oldPaint = g.getPaint();
                        g.setPaint(BandFigure.getRestrictedAreaTexture());
                        g.fillRect(x, b.y, this.columnWidth, b.y + b.height + 1);
                        g.setPaint(oldPaint);
                    }
                    x += this.columnWidth;
                    if (i < this.columnNumber - 1) {
                        Paint p = g.getPaint();
                        g.setPaint(this.tp);
                        g.fillRect(x, b.y, this.columnSpacing, b.y + b.height + 1);
                        g.setPaint(p);
                        g.drawLine(x, b.y, x, b.y + b.height + 1);
                    }
                    x += this.columnSpacing;
                    ++i;
                }
            }
            g.setStroke(oldStroke);
        } else {
            graphics.drawLine(b.x, b.y + b.height - 1, b.x + b.width, b.y + b.height - 1);
        }
    }

    public void setShowBandName(boolean showBandName) {
        this.twriter.setShowName(showBandName);
    }

    public void setBandText(String bandText) {
        this.bandText = bandText;
        this.hiddenText = MessageFormat.format(Messages.BandFigure_hiddenFiguretext, bandText);
        this.twriter.setText(bandText);
    }

    public TexturePaint createTexture() {
        if (this.tp == null) {
            this.tp = EmptyTexture.createTexture(null, null);
        }
        return this.tp;
    }
}

