/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.decorator.IDecorator;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.editor.java2d.J2DScaledGraphics;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;

public class ComponentFigure
extends RectangleFigure {
    protected JRElement jrElement;
    protected JSSDrawVisitor drawVisitor;
    private List<IDecorator> decorators;

    public ComponentFigure() {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
    }

    public void setJRElement(JRElement jrElement, JSSDrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
        this.jrElement = jrElement;
        if (jrElement != null) {
            this.setSize(jrElement.getWidth(), jrElement.getHeight());
        }
    }

    public static Graphics2D getG2D(Graphics graphics) {
        Graphics2D graphics2d = null;
        if (graphics instanceof J2DGraphics) {
            graphics2d = ((J2DGraphics)graphics).getGraphics2D();
        } else if (graphics instanceof J2DScaledGraphics) {
            graphics2d = ((J2DScaledGraphics)graphics).getGraphics2D();
        }
        return graphics2d;
    }

    public void paint(Graphics graphics) {
        block9: {
            Rectangle b = this instanceof HandleBounds ? ((HandleBounds)this).getHandleBounds() : this.getBounds();
            try {
                try {
                    graphics.translate(b.x, b.y);
                    Graphics2D graphics2d = ComponentFigure.getG2D(graphics);
                    if (graphics2d != null) {
                        if (this.drawVisitor != null) {
                            this.drawVisitor.setGraphics2D(graphics2d);
                            this.draw(this.drawVisitor, this.jrElement);
                        } else {
                            graphics2d.drawRect(b.x, b.y, b.width, b.height);
                        }
                    } else {
                        System.out.println("not a 2d");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    graphics.translate(-b.x, -b.y);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                graphics.translate(-b.x, -b.y);
                throw throwable;
            }
            graphics.translate(-b.x, -b.y);
        }
        this.paintBorder(graphics);
        this.paintDecorators(graphics);
    }

    protected void draw(JSSDrawVisitor drawVisitor, JRElement jrElement) {
        if (jrElement instanceof JRComponentElement) {
            drawVisitor.visitComponentElement((JRComponentElement)jrElement);
        }
    }

    public JRElement getJrElement() {
        return this.jrElement;
    }

    protected void paintDecorators(Graphics graphics) {
        if (this.decorators == null) {
            return;
        }
        for (IDecorator d : this.decorators) {
            d.paint(graphics, this);
        }
    }

    public void addDecorator(IDecorator decorator) {
        if (this.decorators == null) {
            this.decorators = new ArrayList<IDecorator>();
        }
        this.decorators.add(decorator);
    }

    public void addDecoratorOnce(IDecorator decorator) {
        if (this.decorators == null) {
            this.decorators = new ArrayList<IDecorator>();
        }
        if (!this.decorators.contains(decorator)) {
            this.decorators.add(decorator);
        }
    }

    public void removeDecorator(IDecorator decorator) {
        if (this.decorators != null) {
            this.decorators.remove(decorator);
        }
    }

    public boolean removeDecorator(Class<? extends IDecorator> dectType) {
        if (this.decorators != null) {
            for (IDecorator decorator : this.decorators) {
                if (!decorator.getClass().equals(dectType)) continue;
                return this.decorators.remove(decorator);
            }
        }
        return false;
    }

    public IDecorator getDecorator(Class<? extends IDecorator> dectType) {
        if (this.decorators != null) {
            for (IDecorator decorator : this.decorators) {
                if (!decorator.getClass().equals(dectType)) continue;
                return decorator;
            }
        }
        return null;
    }
}

