/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.parts.PageEditPart;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ContainerPageFigure
extends APageFigure {
    private Dimension containerSize;

    public ContainerPageFigure(boolean viewMargins, PageEditPart page) {
        super(viewMargins, page);
    }

    public void setContainerSize(Dimension d) {
        this.containerSize = d;
        this.setSize(d);
    }

    @Override
    public void paintFigure(Graphics g) {
        if (this.viewMargins) {
            Rectangle clientArea = this.getClientArea();
            clientArea.x -= this.dx;
            clientArea.y -= this.dy;
            Rectangle rectangle = new Rectangle(clientArea.x, clientArea.y, this.containerSize.width, this.containerSize.height);
            g.setBackgroundColor(this.pageBackground);
            g.fillRectangle(rectangle);
            this.setGridSize(rectangle, g);
        }
        if (this.getBorder() != null) {
            this.getBorder().paint((IFigure)this, g, NO_INSETS);
        }
    }

    @Override
    public Rectangle getHandleBounds() {
        Rectangle clientArea = this.getClientArea();
        clientArea.x -= this.dx;
        clientArea.y -= this.dy;
        Insets insets = this.getInsets();
        return new Rectangle(clientArea.x - insets.right, clientArea.y - insets.top, this.containerSize.width + insets.left + insets.right, this.containerSize.height + insets.top + insets.bottom);
    }

    protected void paintChildren(Graphics graphics) {
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child == this.grid || child.isVisible() && this.isFigureVisible(child)) {
                Rectangle[] clipping = null;
                clipping = this.getClippingStrategy() != null ? this.getClippingStrategy().getClip(child) : new Rectangle[]{child.getBounds()};
                int j = 0;
                while (j < clipping.length) {
                    if (clipping[j].intersects(graphics.getClip(Rectangle.SINGLETON))) {
                        graphics.clipRect(clipping[j]);
                        child.paint(graphics);
                        graphics.restoreState();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

