/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.editor.gef.figures.ACachedGraphics;
import com.jaspersoft.studio.editor.gef.figures.FrameFigure;
import com.jaspersoft.studio.editor.java2d.ImageGraphics2D;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.jasper.LazyImageConverter;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.image.MImage;
import java.awt.Graphics2D;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;

public class ImageFigure
extends FrameFigure {
    public ImageFigure(MImage imageModel) {
        super(imageModel);
    }

    protected void visitElement(JSSDrawVisitor drawVisitor, MGraphicElement model) {
        JRDesignElement element = model.getValue();
        JRPrintElement printElement = LazyImageConverter.getInstance().convertImage(drawVisitor.getReportConverter(), model);
        try {
            printElement.accept((PrintElementVisitor)drawVisitor.getDrawVisitor(), (Object)JSSDrawVisitor.elementOffset((JRElement)element));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    protected void draw(JSSDrawVisitor drawVisitor, JRElement jrElement) {
        Graphics2D oldGraphics = drawVisitor.getGraphics2d();
        if (this.needRefresh(oldGraphics)) {
            this.cachedGraphics = this.getCachedGraphics(oldGraphics);
            drawVisitor.setGraphics2D(this.cachedGraphics);
            this.visitElement(drawVisitor, this.model);
            drawVisitor.setGraphics2D(oldGraphics);
            this.model.setChangedProperty(false);
        } else {
            LazyImageConverter.getInstance().convertImage(drawVisitor.getReportConverter(), this.model);
        }
        this.cachedGraphics.setGraphics(drawVisitor.getGraphics2d());
        this.cachedGraphics.paintCache();
    }

    protected JRPen getLinePen() {
        return ((JRImage)this.getJrElement()).getLinePen();
    }

    @Override
    protected Rectangle calcBorder(JRLineBox jrLineBox) {
        int x = (int)Math.ceil(jrLineBox.getLeftPen().getLineWidth().floatValue() / 2.0f);
        int y = (int)Math.ceil(jrLineBox.getTopPen().getLineWidth().floatValue() / 2.0f);
        int w = (int)Math.ceil(jrLineBox.getRightPen().getLineWidth().floatValue() / 2.0f);
        int h = (int)Math.ceil(jrLineBox.getBottomPen().getLineWidth().floatValue() / 2.0f);
        if (x == 0 && y == 0 && w == 0 && h == 0) {
            JRPen jrPen = this.getLinePen();
            y = x = (int)Math.ceil(jrPen.getLineWidth().floatValue() / 2.0f);
            w = x;
            h = x;
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    protected ACachedGraphics getCachedGraphics(Graphics2D originalGraphics) {
        return new ImageGraphics2D(originalGraphics);
    }
}

