/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.decorator.IElementDecorator;
import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.IModelFigure;
import com.jaspersoft.studio.editor.gef.parts.PageEditPart;
import com.jaspersoft.studio.editor.java2d.J2DUtils;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import net.sf.jasperreports.engine.base.JRBaseReport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReportPageFigure
extends APageFigure {
    private int bandsHeight = 0;
    protected JRBaseReport jrDesign = null;
    protected Color printMarginColor = new Color(170, 168, 255);

    public void setPrintMarginColor(Color printMarginColor) {
        this.printMarginColor = printMarginColor;
    }

    public ReportPageFigure(JRBaseReport jd, boolean viewMargins, PageEditPart page) {
        super(viewMargins, page);
        this.jrDesign = jd;
    }

    public void setBandsHeight(int bandsHeight) {
        this.bandsHeight = bandsHeight;
    }

    @Override
    public void paintFigure(Graphics g) {
        if (this.jrDesign != null && this.viewMargins) {
            Rectangle clientArea = this.getClientArea();
            clientArea.x -= this.dx;
            clientArea.y -= this.dy;
            int pageWidth = this.jrDesign.getPageWidth();
            int pageHeight = this.bandsHeight;
            int leftMargin = this.jrDesign.getLeftMargin();
            int rightMargin = this.jrDesign.getRightMargin();
            Rectangle rectangle = new Rectangle(clientArea.x, clientArea.y, pageWidth, pageHeight);
            g.setBackgroundColor(this.pageBackground);
            g.fillRectangle(rectangle);
            Point topLeft = new Point(clientArea.x + leftMargin, clientArea.y);
            Point topRight = new Point(clientArea.x + pageWidth - rightMargin, clientArea.y);
            Point bottomLeft = new Point(topLeft.x, clientArea.y + pageHeight);
            Point bottomRight = new Point(topRight.x, clientArea.y + pageHeight);
            Graphics2D graphics2d = ComponentFigure.getG2D(g);
            if (graphics2d != null) {
                Stroke oldStroke = graphics2d.getStroke();
                graphics2d.setColor(this.printMarginColor);
                graphics2d.setStroke(new BasicStroke(0.5f));
                graphics2d.setStroke(J2DUtils.getInvertedZoomedStroke(graphics2d.getStroke(), g.getAbsoluteScale()));
                g.drawLine(topLeft.x, topLeft.y, bottomLeft.x, bottomLeft.y);
                g.drawLine(topRight.x, topRight.y, bottomRight.x, bottomRight.y);
                graphics2d.setStroke(oldStroke);
                this.setGridSize(rectangle, g);
            }
        }
        if (this.getBorder() != null) {
            this.getBorder().paint((IFigure)this, g, NO_INSETS);
        }
    }

    protected void paintDecorators(Graphics graphics) {
        List<IElementDecorator> decorators = JaspersoftStudioPlugin.getDecoratorManager().getDecorators();
        if (decorators == null) {
            return;
        }
        JasperReportsConfiguration jConfig = ((ANode)this.page.getModel()).getJasperConfiguration();
        for (IElementDecorator d : decorators) {
            d.paintGlobal(graphics, (IFigure)this, jConfig);
        }
    }

    protected void paintChildren(Graphics graphics) {
        int i = 0;
        while (i < this.getChildren().size()) {
            MGraphicElement model;
            IFigure child = (IFigure)this.getChildren().get(i);
            boolean modelVisible = true;
            if (child instanceof IModelFigure && (model = ((IModelFigure)child).getModel()) != null) {
                modelVisible = ((ANode)model).isVisible();
                child.setVisible(modelVisible);
            }
            if (child.isVisible() && modelVisible && this.isFigureVisible(child)) {
                Rectangle[] clipping = null;
                clipping = this.getClippingStrategy() != null ? this.getClippingStrategy().getClip(child) : new Rectangle[]{child.getBounds()};
                int j = 0;
                while (j < clipping.length) {
                    if (clipping[j].intersects(graphics.getClip(Rectangle.SINGLETON))) {
                        graphics.clipRect(clipping[j]);
                        child.paint(graphics);
                        graphics.restoreState();
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.paintDecorators(graphics);
    }

    @Override
    public Rectangle getHandleBounds() {
        Rectangle clientArea = this.getClientArea();
        clientArea.x -= this.dx;
        clientArea.y -= this.dy;
        int pageWidth = this.jrDesign.getPageWidth();
        int pageHeight = this.bandsHeight;
        Insets insets = this.getInsets();
        return new Rectangle(clientArea.x - insets.right, clientArea.y - insets.top, pageWidth + insets.left + insets.right, pageHeight + insets.top + insets.bottom);
    }
}

