/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures.borders;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;

public class CornerBorder
extends LineBorder {
    private int o = 5;

    public CornerBorder(Color color, int lenght) {
        super(color);
        this.o = lenght;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Graphics2D g;
        Rectangle bounds = figure.getBounds();
        if (figure instanceof HandleBounds) {
            bounds = ((HandleBounds)figure).getHandleBounds();
        }
        if ((g = ComponentFigure.getG2D(graphics)) != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(0.1f));
            if (this.getColor() != null) {
                g.setColor(J2DGraphics.toAWTColor(this.getColor()));
            }
            int bottom = bounds.y + bounds.height - 1;
            int right = bounds.x + bounds.width - 1;
            g.drawLine(bounds.x, bounds.y, bounds.x + this.o, bounds.y);
            g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + this.o);
            g.drawLine(right - this.o, bounds.y, right, bounds.y);
            g.drawLine(right, bounds.y, right, bounds.y + this.o);
            g.drawLine(bounds.x, bottom, bounds.x + this.o, bottom);
            g.drawLine(bounds.x, bottom, bounds.x, bottom - this.o);
            g.drawLine(right - this.o, bottom, right, bottom);
            g.drawLine(right, bottom, right, bottom - this.o);
            if (bounds.width > 50) {
                g.drawLine(bounds.x + bounds.width / 2 - this.o / 2, bounds.y, bounds.x + bounds.width / 2 + this.o / 2, bounds.y);
                g.drawLine(bounds.x + bounds.width / 2 - this.o / 2, bottom, bounds.x + bounds.width / 2 + this.o / 2, bottom);
            }
            g.setStroke(oldStroke);
        }
    }
}

