/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.figures.borders;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.figures.util.RoundGradientPaint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;

public class ShadowBorder
extends AbstractBorder {
    public Insets getInsets(IFigure figure) {
        return new Insets(ReportPageFigure.PAGE_BORDER.top);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Graphics2D g = ComponentFigure.getG2D(graphics);
        if (g != null) {
            Rectangle bounds = figure.getBounds();
            if (figure instanceof HandleBounds) {
                bounds = ((HandleBounds)figure).getHandleBounds();
            }
            this.paintShadowBorder(g, bounds.x - insets.left, bounds.y - insets.top, bounds.width + insets.right + insets.left, bounds.height + insets.top + insets.bottom);
        }
    }

    private void paintShadowBorder(Graphics2D g, int x, int y, int width, int height) {
        Rectangle2D.Double r = new Rectangle2D.Double(x + 10, y, width - 20, 10.0);
        GradientPaint gp = new GradientPaint(0.0f, y + 2, new Color(0, 0, 0, 0), 0.0f, (float)((double)y + 9.5), new Color(0, 0, 0, 60));
        g.setPaint(gp);
        g.fill(r);
        r = new Rectangle2D.Double(x + 10, y + height - 10, width - 20, 10.0);
        gp = new GradientPaint(0.0f, (float)((RectangularShape)r).getY(), new Color(0, 0, 0, 60), 0.0f, (float)(((RectangularShape)r).getY() + 7.5), new Color(0, 0, 0, 0));
        g.setPaint(gp);
        g.fill(r);
        r = new Rectangle2D.Double(x, y + 10, 10.0, height - 20);
        gp = new GradientPaint((float)(((RectangularShape)r).getX() + 2.0), 0.0f, new Color(0, 0, 0, 0), (float)(((RectangularShape)r).getX() + 9.5), 0.0f, new Color(0, 0, 0, 60));
        g.setPaint(gp);
        g.fill(r);
        r = new Rectangle2D.Double(x + width - 10, y + 10, 10.0, height - 20);
        gp = new GradientPaint((float)((RectangularShape)r).getX(), 0.0f, new Color(0, 0, 0, 60), (float)(((RectangularShape)r).getX() + 7.5), 0.0f, new Color(0, 0, 0, 0));
        g.setPaint(gp);
        g.fill(r);
        r = new Rectangle2D.Double(x, y, 10.0, 10.0);
        RoundGradientPaint rgp = new RoundGradientPaint((double)x + 9.5, (float)y + 9.5f, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        g.setPaint(rgp);
        g.fill(r);
        r = new Rectangle2D.Double(x + width - 10, y, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 9.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        g.setPaint(rgp);
        g.fill(r);
        r = new Rectangle2D.Double(x + width - 10, y + height - 10, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        g.setPaint(rgp);
        g.fill(r);
        r = new Rectangle2D.Double(x, y + height - 10, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 9.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        g.setPaint(rgp);
        g.fill(r);
    }
}

