/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.gef.decorator.error.ErrorDecorator;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.figures.FigureFactory;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.figures.borders.CornerBorder;
import com.jaspersoft.studio.editor.gef.figures.borders.ElementLineBorder;
import com.jaspersoft.studio.editor.gef.parts.AJDEditPart;
import com.jaspersoft.studio.editor.gef.parts.IRulerUpdatable;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ElementEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.FigurePageLayoutEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.FigureSelectionEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.SearchParentDragTracker;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.properties.view.ErrorsDialog;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.SWTResourceManager;

public class FigureEditPart
extends AJDEditPart
implements PropertyChangeListener,
IRulerUpdatable {
    private static final String RECTANGLE = "rectangle";
    protected JSSDrawVisitor drawVisitor;
    private PreferenceListener preferenceListener;
    protected JasperReportsConfiguration jConfig;
    private String pref;
    private Color fg;

    public JSSDrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    protected void handlePreferenceChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.equals("elementDesignBorderStyle") || p.equals("elementDesignBorderColor")) {
            this.pref = null;
            this.setPrefsBorder(this.getFigure());
        } else {
            this.refreshVisuals();
        }
    }

    @Override
    public void activate() {
        super.activate();
        this.preferenceListener = new PreferenceListener();
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, this.getAssociatedFile());
        if (this.getModel() != null) {
            this.getModel().getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    @Override
    public void deactivate() {
        if (this.preferenceListener != null) {
            JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        }
        if (this.getModel() != null) {
            this.getModel().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        super.deactivate();
    }

    public void setDrawVisitor(JSSDrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    protected IFigure createFigure() {
        ANode model = this.getModel();
        IFigure rect = FigureFactory.createFigure(model);
        this.setPrefsBorder(rect);
        this.setupFigure(rect);
        return rect;
    }

    public DragTracker getDragTracker(Request request) {
        return new SearchParentDragTracker((EditPart)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FigureSelectionEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FigurePageLayoutEditPolicy());
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && req instanceof SelectionRequest) {
            Point r = ((SelectionRequest)req).getLocation();
            Point tr = this.figure.getBounds().getTopRight();
            this.figure.translateToAbsolute((Translatable)tr);
            if (this.figure instanceof ComponentFigure && ((ComponentFigure)this.figure).getDecorator(ErrorDecorator.class) != null && tr.getDistance(r) < 20.0) {
                ErrorDecorator dec = (ErrorDecorator)((ComponentFigure)this.figure).getDecorator(ErrorDecorator.class);
                org.eclipse.swt.graphics.Point p = this.getViewer().getControl().toDisplay(new org.eclipse.swt.graphics.Point(tr.x, tr.y));
                p.y -= ErrorsDialog.hof;
                new ErrorsDialog().createDialog(null, p, dec.getErrorMessages());
                return;
            }
        }
        super.performRequest(req);
    }

    public void refreshVisuals() {
        Shape rect = (Shape)this.getFigure();
        if (Display.getCurrent() != null) {
            this.setupFigure((IFigure)rect);
            rect.invalidate();
            rect.repaint();
        }
    }

    public JasperReportsConfiguration getjConfig() {
        return this.jConfig;
    }

    public void setPrefsBorder(IFigure rect) {
        if (this.pref == null) {
            if (this.jConfig == null) {
                this.jConfig = this.getModel().getJasperConfiguration();
            }
            this.pref = this.jConfig.getProperty("elementDesignBorderStyle", RECTANGLE);
            String mcolor = this.jConfig.getProperty("elementDesignBorderColor", "0,0,0");
            this.fg = SWTResourceManager.getColor((RGB)StringConverter.asRGB((String)mcolor));
        }
        if (this.pref.equals(RECTANGLE)) {
            rect.setBorder((Border)new ElementLineBorder(this.fg));
        } else {
            rect.setBorder((Border)new CornerBorder(this.fg, 5));
        }
    }

    protected void setupFigure(IFigure rect) {
        ANode model = this.getModel();
        rect.setToolTip((IFigure)new Label(model.getToolTip()));
        if (model instanceof IGraphicElement && model.getValue() != null) {
            Rectangle bounds = ((IGraphicElement)((Object)model)).getBounds();
            int x = bounds.x + ReportPageFigure.PAGE_BORDER.left;
            int y = bounds.y + ReportPageFigure.PAGE_BORDER.top;
            if (model.getValue() instanceof JRDesignElement) {
                JRDesignElement jrElement = (JRDesignElement)model.getValue();
                if (rect instanceof ComponentFigure && this.drawVisitor != null) {
                    ComponentFigure f = (ComponentFigure)rect;
                    f.setLocation(new Point(x, y));
                    f.setJRElement((JRElement)jrElement, this.drawVisitor);
                } else {
                    rect.setBounds(new Rectangle(x, y, jrElement.getWidth(), jrElement.getHeight()));
                }
            } else {
                rect.setBounds(new Rectangle(x, y, bounds.width, bounds.height));
            }
        }
        if (rect instanceof ComponentFigure) {
            JaspersoftStudioPlugin.getDecoratorManager().setupFigure((ComponentFigure)rect, this);
        }
    }

    public ANode getModel() {
        return (ANode)super.getModel();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
    }

    @Override
    public void updateRulers() {
        Rectangle bounds;
        ANode model = this.getModel().getParent();
        if (model instanceof IGraphicElement && model.getValue() != null && (bounds = ((IGraphicElement)((Object)model)).getBounds()) != null) {
            int x = bounds.x + ReportPageFigure.PAGE_BORDER.left;
            int y = bounds.y + ReportPageFigure.PAGE_BORDER.top;
            this.getViewer().setProperty("HOFFSET", (Object)x);
            this.getViewer().setProperty("VOFFSET", (Object)y);
            this.getViewer().setProperty("HEND", (Object)bounds.width);
            this.getViewer().setProperty("VEND", (Object)bounds.height);
            this.getViewer().setProperty("SnapToGrid.GridOrigin", (Object)new Point(x, y));
        }
    }

    public static EditPart getParentEditPart(EditPart childEditPart) {
        if (childEditPart != null && childEditPart.getModel() != null) {
            ANode child = (ANode)childEditPart.getModel();
            ANode parentModel = child.getParent();
            for (Object actualChild : childEditPart.getParent().getChildren()) {
                EditPart actualChildPart = (EditPart)actualChild;
                if (parentModel != actualChildPart.getModel()) continue;
                return actualChildPart;
            }
        }
        return null;
    }

    public EditPart getDropContainer() {
        EditPart parentEditPart;
        if (!(this instanceof IContainer) && (parentEditPart = FigureEditPart.getParentEditPart((EditPart)this)) != null) {
            return parentEditPart;
        }
        return this;
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            FigureEditPart.this.handlePreferenceChanged(event);
        }
    }
}

