/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.commands.SetPageConstraintCommand;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.SnapToGeometryThreshold;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ColoredLayoutPositionRectangle;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.FigureSelectionEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.ISelection;

public class FrameFigureEditPart
extends FigureEditPart
implements IContainer {
    public static Color addElementColor = new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), 128);
    private ColoredLayoutPositionRectangle targetFeedback;

    @Override
    public MFrame getModel() {
        return (MFrame)super.getModel();
    }

    public boolean hasTargetFeedBack() {
        return this.targetFeedback != null;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FigureSelectionEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy(){

            @Override
            protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
                if (parent instanceof MPage) {
                    parent = FrameFigureEditPart.this.getModel();
                }
                Rectangle b = FrameFigureEditPart.this.getModel().getBounds();
                int x = constraint.x - b.x - ReportPageFigure.PAGE_BORDER.left;
                int y = constraint.y - b.y - ReportPageFigure.PAGE_BORDER.top;
                constraint = new Rectangle(x, y, constraint.width, constraint.height);
                return super.getCreateCommand(parent, obj, constraint, index, request);
            }

            protected Command getAddCommand(Request generic) {
                ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
                List editParts = request.getEditParts();
                MFrame mband = FrameFigureEditPart.this.getModel();
                JSSCompoundCommand command = new JSSCompoundCommand(mband);
                command.enableSelectionRestore(true);
                command.setDebugLabel("Add in Frame");
                ISelection currentSelection = null;
                int i = 0;
                while (i < editParts.size()) {
                    GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
                    if (currentSelection == null) {
                        currentSelection = child.getViewer().getSelection();
                    }
                    command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
                    ++i;
                }
                return command;
            }

            protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
                Rectangle rect = (Rectangle)constraint;
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    if (cmodel.getParent() instanceof MFrame && cmodel.getParent() == FrameFigureEditPart.this.getModel()) {
                        SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                        MGraphicElement model = (MGraphicElement)child.getModel();
                        Rectangle r = model.getBounds();
                        JRDesignElement jde = model.getValue();
                        int x = r.x + rect.x - jde.getX() + 1;
                        int y = r.y + rect.y - jde.getY() + 1;
                        rect.setLocation(x, y);
                        cmd.setContext(FrameFigureEditPart.this.getModel(), (ANode)child.getModel(), rect);
                        return cmd;
                    }
                    CompoundCommand c = new CompoundCommand();
                    ++rect.y;
                    c.add(OutlineTreeEditPartFactory.getOrphanCommand(cmodel.getParent(), cmodel));
                    CreateElementCommand createCommand = new CreateElementCommand(FrameFigureEditPart.this.getModel(), cmodel, rect, -1);
                    createCommand.setApplyDefault(false);
                    c.add((Command)createCommand);
                    return c;
                }
                return super.createChangeConstraintCommand(child, constraint);
            }

            @Override
            protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
                Rectangle rect = ((Rectangle)constraint).getCopy();
                if (child.getModel() instanceof MGraphicElement) {
                    SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                    MGraphicElement model = (MGraphicElement)child.getModel();
                    Rectangle r = model.getBounds();
                    JRDesignElement jde = model.getValue();
                    int x = r.x + rect.x - jde.getX() + 1;
                    int y = r.y + rect.y - jde.getY() + 1;
                    rect.setLocation(x, y);
                    cmd.setContext(FrameFigureEditPart.this.getModel(), (ANode)child.getModel(), rect);
                    return cmd;
                }
                return null;
            }

            protected void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                this.getLayoutTargetFeedback(request);
            }

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (FrameFigureEditPart.this.targetFeedback != null) {
                    this.removeFeedback((IFigure)FrameFigureEditPart.this.targetFeedback);
                    FrameFigureEditPart.this.targetFeedback = null;
                }
            }

            protected IFigure getLayoutTargetFeedback(Request request) {
                if (FrameFigureEditPart.this.targetFeedback == null) {
                    CreateRequest cbr;
                    Point mouseLocation = null;
                    ArrayList<Object> nodes = new ArrayList<Object>();
                    if (request.getType().equals("create child") && request instanceof CreateRequest) {
                        cbr = (CreateRequest)request;
                        mouseLocation = cbr.getLocation();
                        if (cbr.getNewObject() instanceof Collection) {
                            Collection c = (Collection)cbr.getNewObject();
                            if (!c.isEmpty()) {
                                for (Object obj : c) {
                                    if (!(obj instanceof MField)) continue;
                                    nodes.add((MField)obj);
                                }
                            }
                        } else {
                            nodes.add(cbr.getNewObject());
                        }
                    } else if (request instanceof ChangeBoundsRequest) {
                        cbr = (ChangeBoundsRequest)request;
                        mouseLocation = cbr.getLocation();
                        List lst = cbr.getEditParts();
                        for (EditPart ep : lst) {
                            nodes.add(ep.getModel());
                        }
                    }
                    int index = -1;
                    if (mouseLocation != null) {
                        IFigure bandFigure = FrameFigureEditPart.this.getFigure();
                        Point location = mouseLocation.getCopy();
                        bandFigure.translateToRelative((Translatable)location);
                        Dimension newLocation = location.getDifference(bandFigure.getBounds().getTopLeft());
                        index = ModelUtils.getBetweenIndex(FrameFigureEditPart.this.getModel(), new Point(newLocation.width, newLocation.height));
                    }
                    FrameFigureEditPart.this.targetFeedback = new ColoredLayoutPositionRectangle((EditPart)FrameFigureEditPart.this, addElementColor, 2.0f, FrameFigureEditPart.this.getModel(), nodes, index);
                    FrameFigureEditPart.this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    double zoom = 1.0;
                    ZoomManager zoomMgr = (ZoomManager)FrameFigureEditPart.this.getViewer().getProperty(ZoomManager.class.toString());
                    if (zoomMgr != null) {
                        zoom = zoomMgr.getZoom();
                    }
                    rect.scale(zoom);
                    FrameFigureEditPart.this.targetFeedback.setBounds((Rectangle)rect);
                    this.addFeedback((IFigure)FrameFigureEditPart.this.targetFeedback);
                }
                return FrameFigureEditPart.this.targetFeedback;
            }
        });
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWRULER", Boolean.TRUE);
            Boolean stg = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGUIDES", Boolean.TRUE);
            if (val.booleanValue() && stg != null && stg.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGEOMETRY", Boolean.TRUE)).booleanValue()) {
                SnapToGeometryThreshold snapper = new SnapToGeometryThreshold((GraphicalEditPart)this);
                snapper.setThreshold(2.0);
                snapStrategies.add((Object)snapper);
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGRID", Boolean.TRUE)).booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }
}

