/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.callout.pin.MPinConnection;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.figures.ContainerPageFigure;
import com.jaspersoft.studio.editor.gef.figures.GridPainter;
import com.jaspersoft.studio.editor.gef.figures.borders.ShadowBorder;
import com.jaspersoft.studio.editor.gef.figures.borders.SimpleShadowBorder;
import com.jaspersoft.studio.editor.gef.parts.AJDEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.SnapToGeometryThreshold;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.JSSSnapFeedBackPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.swt.SWTResourceManager;

public class PageEditPart
extends AJDEditPart
implements PropertyChangeListener {
    private PreferenceListener preferenceListener;
    protected JasperReportsConfiguration jConfig;
    private PropertyChangeListener gridListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("SnapToGrid.GridOrigin")) {
                PageEditPart.this.refreshGridLayer();
            }
        }
    };
    private boolean isRefreshing = false;
    private java.beans.PropertyChangeEvent pendingRefreshRequestEvent = null;

    protected void handlePreferencesChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.equals("pageDesignBorderStyle")) {
            this.setPrefsBorder(this.getFigure());
        }
        if (p.equals("pageRulerGrid_SHOWRULER")) {
            Boolean val = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWRULER", Boolean.TRUE);
            this.getViewer().setProperty("ruler$visibility", (Object)val);
        } else if (p.equals("gridColor") || p.equals("pageRulerGrid_SHOWGRID") || p.equals("pageRulerGrid_GRIDSPACEY") || p.equals("pageRulerGrid_GRIDSPACEX")) {
            this.refreshGridLayer();
        }
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                PageEditPart.this.refreshVisuals();
            }
        });
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWRULER", Boolean.TRUE);
            Boolean stg = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGUIDES", Boolean.TRUE);
            if (val.booleanValue() && stg != null && stg.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGEOMETRY", Boolean.TRUE)).booleanValue()) {
                SnapToGeometryThreshold snapper = new SnapToGeometryThreshold((GraphicalEditPart)this);
                snapper.setThreshold(6.0);
                snapStrategies.add((Object)snapper);
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGRID", Boolean.TRUE)).booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    @Override
    public void activate() {
        super.activate();
        ANode node = (ANode)this.getModel();
        node.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.preferenceListener = new PreferenceListener();
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, this.getAssociatedFile());
    }

    @Override
    public void deactivate() {
        ANode node = (ANode)this.getModel();
        node.getPropertyChangeSupport().removePropertyChangeListener(this);
        if (this.preferenceListener != null) {
            JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        }
        super.deactivate();
    }

    protected void setPrefsBorder(IFigure rect) {
        String pref;
        if (this.jConfig == null) {
            this.jConfig = ((APropertyNode)this.getModel()).getJasperConfiguration();
        }
        if ((pref = this.jConfig.getProperty("pageDesignBorderStyle", "shadow")).equals("shadow")) {
            rect.setBorder((Border)new ShadowBorder());
        } else {
            rect.setBorder((Border)new SimpleShadowBorder());
        }
    }

    protected void refreshGridLayer() {
        if (this.jConfig != null) {
            boolean visible = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWGRID", true);
            GridPainter grid = ((APageFigure)this.getFigure()).getGrid();
            grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
            int x = this.jConfig.getPropertyInteger("pageRulerGrid_GRIDSPACEX", 10);
            int y = this.jConfig.getPropertyInteger("pageRulerGrid_GRIDSPACEY", 10);
            grid.setSpacing(new Dimension(x, y));
            grid.setVisible(visible);
            this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(x, y));
            String mcolor = this.jConfig.getProperty("gridColor", "192,192,192");
            Color fg = SWTResourceManager.getColor((RGB)StringConverter.asRGB((String)mcolor));
            grid.setForegroundColor(fg);
        }
    }

    protected void register() {
        super.register();
        this.getViewer().addPropertyChangeListener(this.gridListener);
        this.refreshGridLayer();
    }

    protected void unregister() {
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
    }

    public Object getModel() {
        Object model = super.getModel();
        if (model instanceof MRoot) {
            return ((MRoot)model).getChildren().get(0);
        }
        return model;
    }

    public ANode getPage() {
        return (ANode)this.getModel();
    }

    public JasperDesign getJasperDesign() {
        return this.getPage().getJasperDesign();
    }

    protected IFigure createFigure() {
        APageFigure figure = this.newPageFigure();
        this.setPrefsBorder((IFigure)figure);
        this.setupPageFigure(figure);
        figure.setOpaque(false);
        figure.setBackgroundColor(ColorConstants.white);
        figure.setLayoutManager((LayoutManager)new XYLayout());
        this.updateRullers();
        return figure;
    }

    protected APageFigure newPageFigure() {
        return new ContainerPageFigure(true, this);
    }

    protected void setupPageFigure(APageFigure figure2) {
        JasperDesign jd = this.getJasperDesign();
        int w = 2000;
        int h = 5000;
        figure2.setSize(w, h);
        this.getViewer().setProperty("RULER_HOFFSET", (Object)APageFigure.PAGE_BORDER.left);
        this.getViewer().setProperty("RULER_VOFFSET", (Object)APageFigure.PAGE_BORDER.top);
        this.getViewer().setProperty("RULER_HEND", (Object)jd.getPageWidth());
        this.getViewer().setProperty("RULER_VEND", (Object)(jd.getPageHeight() - APageFigure.PAGE_BORDER.top));
        this.getViewer().setProperty("SnapToGrid.GridOrigin", (Object)new Point(APageFigure.PAGE_BORDER.left, APageFigure.PAGE_BORDER.top));
        this.setupPagePreferences(figure2);
    }

    protected void setupPagePreferences(APageFigure figure2) {
        String mcolor = this.jConfig.getProperty("pageBackground", "255,255,255");
        figure2.setPageBackground(SWTResourceManager.getColor((RGB)StringConverter.asRGB((String)mcolor)));
    }

    public void updateRullers() {
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new JSSSnapFeedBackPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        return this.getRoot().getDragTracker(request);
    }

    protected List<Object> getModelChildren() {
        final ArrayList<Object> list = new ArrayList<Object>();
        new ModelVisitor<Object>((INode)this.getPage()){

            @Override
            public boolean visit(INode n) {
                if (n instanceof MCallout) {
                    list.add(n);
                    for (INode child : n.getChildren()) {
                        if (child instanceof MPinConnection) continue;
                        list.add(child);
                    }
                } else if (n instanceof IGraphicElement && n.getValue() != null) {
                    list.add(n);
                }
                return true;
            }
        };
        return list;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure layer;
        if (childEditPart instanceof IContainerPart) {
            IFigure layer2 = this.getLayer("SECTIONS_LAYER");
            if (layer2 != null) {
                layer2.add(((AbstractGraphicalEditPart)childEditPart).getFigure());
            }
        } else if ((childEditPart instanceof FigureEditPart || childEditPart instanceof CalloutEditPart || childEditPart instanceof PinEditPart) && (layer = this.getLayer("ELEMENTS_LAYER")) != null) {
            layer.add(((AJDEditPart)childEditPart).getFigure());
        }
        super.addChildVisual(childEditPart, index);
    }

    private void repaintPartFigure(APageFigure figure) {
        this.setupPageFigure(figure);
        for (Object i : this.getChildren()) {
            if (!(i instanceof EditPart)) continue;
            ((EditPart)i).refresh();
        }
        figure.repaint();
    }

    public void refreshVisuals() {
        final APageFigure figure = (APageFigure)this.getFigure();
        if (Display.getCurrent() != null) {
            this.repaintPartFigure(figure);
        } else {
            Display globalDisplay = UIUtils.getDisplay();
            if (globalDisplay != null) {
                globalDisplay.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageEditPart.this.repaintPartFigure(figure);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(java.beans.PropertyChangeEvent arg0) {
        PageEditPart pageEditPart = this;
        synchronized (pageEditPart) {
            if (this.isRefreshing) {
                if (this.pendingRefreshRequestEvent == null) {
                    this.pendingRefreshRequestEvent = arg0;
                } else if ("refreshUIEvent".equals(arg0.getPropertyName())) {
                    this.pendingRefreshRequestEvent = arg0;
                }
                return;
            }
            this.isRefreshing = true;
        }
        try {
            if ("refreshUIEvent".equals(arg0.getPropertyName()) || !JSSCompoundCommand.isRefreshEventsIgnored((ANode)this.getModel())) {
                this.refreshChildren();
                IEditorPart refreshedEditor = ((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart();
                AbstractVisualEditor visualEditor = (AbstractVisualEditor)refreshedEditor;
                if (visualEditor == null || visualEditor.isEditorVisible()) {
                    this.refreshVisuals();
                    visualEditor.layout();
                }
            }
        }
        finally {
            this.isRefreshing = false;
            if (this.pendingRefreshRequestEvent != null) {
                java.beans.PropertyChangeEvent pendingRequest = this.pendingRefreshRequestEvent;
                this.pendingRefreshRequestEvent = null;
                this.propertyChange(pendingRequest);
            }
        }
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PageEditPart.this.handlePreferencesChanged(event);
        }
    }
}

