/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts;

import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.callout.pin.MPinConnection;
import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.PageEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.NotMovablePartDragTracker;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.property.dataset.dialog.IDatasetDialogSupport;
import com.jaspersoft.studio.utils.ModelUtils;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class ReportPageEditPart
extends PageEditPart
implements PropertyChangeListener,
IDatasetDialogSupport {
    @Override
    protected APageFigure newPageFigure() {
        return new ReportPageFigure((JRBaseReport)this.getJasperDesign(), true, this);
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new NotMovablePartDragTracker((EditPart)this);
    }

    @Override
    protected void setupPageFigure(APageFigure figure2) {
        JasperDesign jd = this.getJasperDesign();
        List<JRBand> bands = ModelUtils.getAllBands(jd);
        int dh = ModelUtils.getDesignHeight(bands);
        int designHeight = dh + jd.getTopMargin() + jd.getBottomMargin();
        int w = jd.getPageWidth() + 20;
        int h = designHeight + 10;
        ReportPageFigure rpFig = (ReportPageFigure)figure2;
        rpFig.setBandsHeight(designHeight);
        this.setupPagePreferences(figure2);
        figure2.setSize(w, h);
    }

    @Override
    protected void setupPagePreferences(APageFigure figure2) {
        String mcolor = this.jConfig.getProperty("pageMarginColor", "170,168,255");
        RGB rgb = StringConverter.asRGB((String)mcolor);
        ((ReportPageFigure)figure2).setPrintMarginColor(new Color(rgb.red, rgb.green, rgb.blue));
        super.setupPagePreferences(figure2);
    }

    @Override
    public void updateRullers() {
        JasperDesign jd = this.getJasperDesign();
        List<JRBand> bands = ModelUtils.getAllBands(jd);
        int dh = ModelUtils.getDesignHeight(bands);
        int tx = jd.getLeftMargin() + ReportPageFigure.PAGE_BORDER.left;
        int ty = jd.getTopMargin() + ReportPageFigure.PAGE_BORDER.top;
        this.getViewer().setProperty("HOFFSET", (Object)tx);
        this.getViewer().setProperty("VOFFSET", (Object)ty);
        this.getViewer().setProperty("HEND", (Object)(jd.getPageWidth() - jd.getLeftMargin() - jd.getRightMargin()));
        this.getViewer().setProperty("VEND", (Object)dh);
        this.getViewer().setProperty("SnapToGrid.GridOrigin", (Object)new Point(tx, ReportPageFigure.PAGE_BORDER.top + jd.getTopMargin()));
    }

    @Override
    protected List<Object> getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Object> sList = new ArrayList<Object>();
        for (INode node : this.getPage().getChildren()) {
            if (node instanceof MBackgrounImage) {
                list.add(0, node);
                continue;
            }
            if (node instanceof MCallout) {
                sList.add(node);
                for (INode n : node.getChildren()) {
                    if (n instanceof MPinConnection) continue;
                    sList.add(n);
                }
                continue;
            }
            if (!(node instanceof IGraphicElement) || node.getValue() == null) continue;
            if (node instanceof MBand) {
                MBand band = (MBand)node;
                list.add(band);
                this.getNodeChildren(node, sList);
                continue;
            }
            sList.add(node);
        }
        list.addAll(sList);
        return list;
    }

    private void getNodeChildren(INode node, List<Object> list) {
        if (node.showChildren()) {
            for (INode nod : node.getChildren()) {
                if (nod instanceof IGraphicElement) {
                    list.add(nod);
                }
                this.getNodeChildren(nod, list);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        ANode model;
        if (arg0.getSource() instanceof MReport && (model = (ANode)this.getModel()).getChildren() != null) {
            for (Object node : this.getModelChildren()) {
                EditPart ep;
                if (!(node instanceof INode) || !((ep = (EditPart)this.getViewer().getEditPartRegistry().get(node)) instanceof PropertyChangeListener)) continue;
                ((PropertyChangeListener)ep).propertyChange(arg0);
            }
        }
        super.propertyChange(arg0);
    }
}

