/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.editor.gef.commands.SetPositionCommand;
import com.jaspersoft.studio.editor.gef.figures.BandFigure;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.APrefFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FrameFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.editor.gef.parts.SnapToGeometryThreshold;
import com.jaspersoft.studio.editor.gef.parts.band.BandMoveEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.band.BandResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.band.NotMovablePartDragTracker;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ColoredLayoutPositionRectangle;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.JSSSnapFeedBackPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.dataset.dialog.IDatasetDialogSupport;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;

public class BandEditPart
extends APrefFigureEditPart
implements PropertyChangeListener,
IContainerPart,
IContainer,
IDatasetDialogSupport {
    @Override
    protected void handlePreferenceChanged(PropertyChangeEvent event) {
        if (event.getProperty().equals("showReportBandNames")) {
            this.setBandNameShowing(this.getFigure());
        } else {
            super.handlePreferenceChanged(event);
        }
    }

    public BandFigure getFigure() {
        return (BandFigure)super.getFigure();
    }

    public JRDesignBand getBand() {
        return this.getModel().getValue();
    }

    @Override
    public MBand getModel() {
        return (MBand)super.getModel();
    }

    @Override
    public void performRequest(Request req) {
        int bandHeight;
        if ("open".equals(req.getType()) && (bandHeight = ModelUtils.getBandHeight((JRBand)this.getBand())) > 0) {
            SetValueCommand cmd = new SetValueCommand();
            cmd.setTarget(this.getModel());
            cmd.setPropertyId("height");
            cmd.setPropertyValue(bandHeight);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)cmd);
        }
        super.performRequest(req);
    }

    public JasperDesign getJasperDesign() {
        try {
            return this.getModel().getJasperDesign();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        if (SelectionHelper.isBackgroundEditable()) {
            return SelectionHelper.getBackgroundEditPart().getDragTracker(request);
        }
        return new NotMovablePartDragTracker((EditPart)this);
    }

    @Override
    protected IFigure createFigure() {
        JRDesignBand jrBand = this.getBand();
        BandTypeEnum bandTypeValue = jrBand.getOrigin().getBandTypeValue();
        boolean drawColumns = bandTypeValue.equals((Object)BandTypeEnum.COLUMN_FOOTER) || bandTypeValue.equals((Object)BandTypeEnum.COLUMN_HEADER) || bandTypeValue.equals((Object)BandTypeEnum.GROUP_FOOTER) || bandTypeValue.equals((Object)BandTypeEnum.GROUP_HEADER) || bandTypeValue.equals((Object)BandTypeEnum.COLUMN_HEADER) || bandTypeValue.equals((Object)BandTypeEnum.DETAIL);
        BandFigure rect = new BandFigure(drawColumns, this.getModel());
        rect.setForegroundColor(ColorConstants.blue);
        this.setupBandFigure((IFigure)rect);
        this.figure = rect;
        this.setBandNameShowing(rect);
        this.setMarginColor();
        return rect;
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = this.jConfig.getPropertyBoolean("pageRulerGrid_SHOWRULER", Boolean.TRUE);
            Boolean stg = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGUIDES", Boolean.TRUE);
            if (val.booleanValue() && stg != null && stg.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGEOMETRY", Boolean.TRUE)).booleanValue()) {
                SnapToGeometryThreshold snapper = new SnapToGeometryThreshold((GraphicalEditPart)this);
                snapper.setThreshold(2.0);
                snapStrategies.add((Object)snapper);
            }
            if ((val = this.jConfig.getPropertyBoolean("pageRulerGrid_SNAPTOGRID", Boolean.TRUE)).booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new JSSSnapFeedBackPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new BandMoveEditPolicy(){

            @Override
            protected void showSelection() {
                BandEditPart.this.updateRulers();
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy(){
            private ColoredLayoutPositionRectangle targetFeedback;

            protected Command getAddCommand(Request generic) {
                ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
                List editParts = request.getEditParts();
                MBand mband = BandEditPart.this.getModel();
                JSSCompoundCommand command = new JSSCompoundCommand(mband);
                command.enableSelectionRestore(true);
                command.setDebugLabel("Add in Band");
                ISelection currentSelection = null;
                int i = 0;
                while (i < editParts.size()) {
                    GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
                    if (currentSelection == null) {
                        currentSelection = child.getViewer().getSelection();
                    }
                    command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
                    ++i;
                }
                return command;
            }

            @Override
            protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
                Rectangle rect = constraint.getCopy();
                rect = rect.getTranslated(-ReportPageFigure.PAGE_BORDER.left, -ReportPageFigure.PAGE_BORDER.right);
                return super.getCreateCommand(parent, obj, rect, index, request);
            }

            protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
                Rectangle rect = ((Rectangle)constraint).getCopy();
                rect = rect.getTranslated(-ReportPageFigure.PAGE_BORDER.left, -ReportPageFigure.PAGE_BORDER.right);
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    MBand mband = BandEditPart.this.getModel();
                    if (cmodel.getParent() instanceof MBand && cmodel.getParent() == mband) {
                        return super.createChangeConstraintCommand(child, rect);
                    }
                    CompoundCommand c = new CompoundCommand();
                    c.add(OutlineTreeEditPartFactory.getOrphanCommand(cmodel.getParent(), cmodel));
                    CreateElementCommand createCommand = new CreateElementCommand(mband, cmodel, CreateElementCommand.fixLocation(rect, mband, cmodel.getValue()), -1);
                    createCommand.setApplyDefault(false);
                    c.add((Command)createCommand);
                    return c;
                }
                if (child instanceof CalloutEditPart) {
                    return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                if (child instanceof PinEditPart) {
                    return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                return null;
            }

            @Override
            protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
                Rectangle rect = ((Rectangle)constraint).getCopy();
                rect = rect.getTranslated(-ReportPageFigure.PAGE_BORDER.left, -ReportPageFigure.PAGE_BORDER.right);
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    SetPositionCommand command = new SetPositionCommand();
                    command.setContext(cmodel, this.adaptConstraint(rect));
                    return command;
                }
                return null;
            }

            protected void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                this.getLayoutTargetFeedback(request);
            }

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (this.targetFeedback != null) {
                    this.removeFeedback((IFigure)this.targetFeedback);
                    this.targetFeedback = null;
                }
            }

            protected IFigure getLayoutTargetFeedback(Request request) {
                CreateRequest cbr;
                ArrayList<Object> nodes = new ArrayList<Object>();
                Point mouseLocation = null;
                if (request.getType().equals("create child") && request instanceof CreateRequest) {
                    cbr = (CreateRequest)request;
                    mouseLocation = cbr.getLocation();
                    if (cbr.getNewObject() instanceof Collection) {
                        Collection c = (Collection)cbr.getNewObject();
                        if (!c.isEmpty()) {
                            for (Object obj : c) {
                                if (obj instanceof MStyle) {
                                    return null;
                                }
                                if (!(obj instanceof MField)) continue;
                                nodes.add((MField)obj);
                            }
                        }
                    } else {
                        nodes.add(cbr.getNewObject());
                    }
                } else if (request instanceof ChangeBoundsRequest) {
                    cbr = (ChangeBoundsRequest)request;
                    mouseLocation = cbr.getLocation();
                    List lst = cbr.getEditParts();
                    for (EditPart ep : lst) {
                        if (((ANode)ep.getModel()).getParent() == BandEditPart.this.getModel()) {
                            nodes.clear();
                            return null;
                        }
                        nodes.add(ep.getModel());
                    }
                }
                if (this.targetFeedback == null) {
                    int index = -1;
                    if (mouseLocation != null) {
                        BandFigure bandFigure = BandEditPart.this.getFigure();
                        Point location = mouseLocation.getCopy();
                        bandFigure.translateToRelative((Translatable)location);
                        Dimension newLocation = location.getDifference(bandFigure.getBounds().getTopLeft());
                        index = ModelUtils.getBetweenIndex(BandEditPart.this.getModel(), new Point(newLocation.width, newLocation.height));
                    }
                    this.targetFeedback = new ColoredLayoutPositionRectangle((EditPart)BandEditPart.this, FrameFigureEditPart.addElementColor, 2.0f, BandEditPart.this.getModel(), nodes, index);
                    this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    double zoom = 1.0;
                    ZoomManager zoomMgr = (ZoomManager)BandEditPart.this.getViewer().getProperty(ZoomManager.class.toString());
                    if (zoomMgr != null) {
                        zoom = zoomMgr.getZoom();
                    }
                    rect.scale(zoom);
                    this.targetFeedback.setBounds((Rectangle)rect);
                    this.addFeedback((IFigure)this.targetFeedback);
                }
                return this.targetFeedback;
            }
        });
    }

    @Override
    public EditPolicy getEditPolicy() {
        return new BandResizableEditPolicy();
    }

    public boolean isSelectable() {
        return true;
    }

    public static String className(Object cls) {
        String className = cls.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public void refreshVisuals() {
        BandFigure rect = this.getFigure();
        this.setupBandFigure((IFigure)rect);
        if (Display.getCurrent() != null) {
            rect.repaint();
        }
    }

    private void setupBandFigure(IFigure rect) {
        JRDesignBand jrBand = this.getBand();
        MBand bandNode = this.getModel();
        Rectangle bounds = bandNode.getBounds();
        JasperDesign jasperDesign = this.getJasperDesign();
        BandFigure bfig = (BandFigure)rect;
        bfig.setMarginLeft(jasperDesign.getLeftMargin());
        bfig.setMarginRight(jasperDesign.getRightMargin());
        bfig.setColumnNumber(jasperDesign.getColumnCount());
        bfig.setColumnWidth(jasperDesign.getColumnWidth());
        bfig.setColumnSpacing(jasperDesign.getColumnSpacing());
        int width = jasperDesign.getPageWidth() + 1;
        int height = jrBand != null ? jrBand.getHeight() + 1 : 0;
        rect.setBounds(new Rectangle(ReportPageFigure.PAGE_BORDER.left, bounds.y + ReportPageFigure.PAGE_BORDER.top, width, height));
        bfig.setToolTip((IFigure)new Label(bandNode.getToolTip()));
        bfig.setBandText(bandNode.getSimpleDisplayName());
        if (this.getSelected() == 1) {
            this.updateRulers();
        } else {
            EditPartViewer viewer = this.getViewer();
            if (viewer != null) {
                List selected = viewer.getSelectedEditParts();
                if (selected.isEmpty()) {
                    this.updateRulers();
                } else {
                    for (Object obj : selected) {
                        FigureEditPart figEditPart;
                        if (!(obj instanceof FigureEditPart) || (figEditPart = (FigureEditPart)obj).getModel().getParent() != bandNode) continue;
                        figEditPart.updateRulers();
                    }
                }
            }
        }
    }

    @Override
    public void updateRulers() {
        EditPart ep = this.getParent();
        if (ep instanceof ReportPageEditPart) {
            ((ReportPageEditPart)ep).updateRullers();
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
    }

    @Override
    public Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        return new Rectangle(0, 0, 0, request.getSizeDelta().height);
    }

    private void setBandNameShowing(BandFigure figure) {
        if (this.jConfig == null) {
            this.jConfig = this.getModel().getJasperConfiguration();
        }
        boolean showBandName = this.jConfig.getPropertyBoolean("showReportBandNames", true);
        figure.setShowBandName(showBandName);
        this.refreshVisuals();
    }

    @Override
    public Dimension getContaierSize() {
        return null;
    }

    @Override
    protected void setupMarginColor() {
        ((BandFigure)this.figure).setMarginsColor(this.getMarginColor());
    }
}

