/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class BandResizeHandleLocator
extends RelativeLocator {
    private double relativeY;

    public BandResizeHandleLocator(IFigure reference, int location) {
        this.setReferenceFigure(reference);
        switch (location & 5) {
            case 1: {
                this.relativeY = 0.0;
                break;
            }
            case 4: {
                this.relativeY = 1.0;
                break;
            }
            default: {
                this.relativeY = 0.5;
            }
        }
    }

    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        targetBounds.resize(1, 1);
        Dimension targetSize = target.getPreferredSize();
        targetBounds.x += 7;
        targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)((targetSize.height + 1) / 2));
        targetBounds.setSize(targetBounds.width - 14, 7);
        target.setBounds((Rectangle)targetBounds);
    }
}

