/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.band;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.figures.BandFigure;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.widgets.Display;

public class BandResizeTracker
extends SimpleDragTracker {
    private EditPart editpart;
    private AutoexposeHelper exposeHelper;
    private SnapToHelper snapToHelper;
    private PrecisionRectangle sourceRectangle;
    private PrecisionRectangle compoundSrcRect;
    static final int MODIFIER_NO_SNAPPING = "macosx".equals(Platform.getOS()) ? 262144 : 65536;

    public void deactivate() {
        super.deactivate();
        this.setAutoexposeHelper(null);
        this.snapToHelper = null;
        this.sourceRectangle = null;
        this.compoundSrcRect = null;
    }

    protected void doAutoexpose() {
        if (this.exposeHelper == null) {
            return;
        }
        if (this.exposeHelper.step(this.getLocation())) {
            this.handleAutoexpose();
            Display.getDefault().asyncExec((Runnable)new QueuedAutoexpose());
        } else {
            this.setAutoexposeHelper(null);
        }
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        this.exposeHelper = helper;
        if (this.exposeHelper == null) {
            return;
        }
        Display.getDefault().asyncExec((Runnable)new QueuedAutoexpose());
    }

    protected void updateAutoexposeHelper() {
        if (this.exposeHelper != null) {
            return;
        }
        AutoexposeHelper.Search search = new AutoexposeHelper.Search(this.getLocation());
        this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), (Collection)Collections.EMPTY_LIST, (EditPartViewer.Conditional)search);
        this.setAutoexposeHelper(search.result);
    }

    protected void handleAutoexpose() {
        this.handleMove();
        this.handleDragInProgress();
    }

    public BandResizeTracker(EditPart sourceEditPart) {
        this.setSourceEditPart(sourceEditPart);
        this.setAutoexposeHelper((AutoexposeHelper)new ViewportAutoexposeHelper((GraphicalEditPart)sourceEditPart.getViewer().getRootEditPart()));
        this.updateAutoexposeHelper();
    }

    protected boolean handleDoubleClick(int button) {
        if (this.getSourceEditPart() != null && button == 1) {
            SelectionRequest request = new SelectionRequest();
            request.setLocation(this.getLocation());
            request.setType((Object)"open");
            this.getSourceEditPart().performRequest((Request)request);
        }
        return true;
    }

    protected String getCommandName() {
        return "move";
    }

    protected String getDebugName() {
        return "Section Resize Handle Tracker";
    }

    protected EditPart getSourceEditPart() {
        return this.editpart;
    }

    protected void setSourceEditPart(EditPart part) {
        this.editpart = part;
        this.snapToHelper = null;
        if (this.editpart != null && this.getOperationSet().size() > 0) {
            this.snapToHelper = (SnapToHelper)this.editpart.getParent().getAdapter(SnapToHelper.class);
        }
    }

    protected List<EditPart> createOperationSet() {
        List<EditPart> editparts = null;
        if (this.editpart == null) {
            editparts = Collections.emptyList();
        } else {
            editparts = new ArrayList();
            editparts.add(this.editpart);
            ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)this.getSourceRequest());
        }
        return editparts;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        return request;
    }

    protected void setState(int state) {
        super.setState(state);
        this.captureSourceDimensions();
    }

    private void captureSourceDimensions() {
        List editparts = this.getOperationSet();
        int i = 0;
        while (i < editparts.size()) {
            GraphicalEditPart child = (GraphicalEditPart)editparts.get(i);
            IFigure figure = child.getFigure();
            PrecisionRectangle bounds = null;
            bounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)bounds);
            this.compoundSrcRect = this.compoundSrcRect == null ? new PrecisionRectangle((Rectangle)bounds) : this.compoundSrcRect.union(bounds);
            if (child == this.getSourceEditPart()) {
                this.sourceRectangle = bounds;
            }
            ++i;
        }
        if (this.sourceRectangle == null) {
            IFigure figure = ((GraphicalEditPart)this.getSourceEditPart()).getFigure();
            this.sourceRectangle = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)this.sourceRectangle);
        }
    }

    protected void snapPoint(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta();
        if (this.editpart != null && this.getOperationSet().size() > 0) {
            this.snapToHelper = (SnapToHelper)this.editpart.getParent().getAdapter(SnapToHelper.class);
        }
        if (this.snapToHelper != null && !this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING)) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            PrecisionRectangle jointRect = this.compoundSrcRect.getPreciseCopy();
            baseRect.translate(moveDelta);
            jointRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            this.snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect, jointRect}, preciseDelta);
            request.setMoveDelta((Point)preciseDelta);
        }
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        EditPart part = null;
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        command.setDebugLabel("Move Section Handle Tracker");
        int i = 0;
        while (i < editparts.size()) {
            part = (EditPart)editparts.get(i);
            command.setReferenceNodeIfNull(part.getModel());
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    protected boolean conditionallyUpdateSourceRequest() {
        boolean inBoundContidion;
        Dimension d = this.getDragMoveDelta();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        BandEditPart part = (BandEditPart)this.getOperationSet().get(0);
        BandFigure figure = part.getFigure();
        int oldHeight = 0;
        oldHeight = part.getModel() != null ? part.getModel().getBounds().height() : figure.getBounds().height - 1;
        ZoomManager zoomMgr = (ZoomManager)part.getViewer().getProperty(ZoomManager.class.toString());
        int deltaHeight = (int)Math.round((double)d.height / zoomMgr.getZoom());
        int newHeight = oldHeight + deltaHeight;
        int maxBandHeight = ModelUtils.getMaxBandHeight(part.getBand(), part.getJasperDesign());
        boolean bl = inBoundContidion = newHeight > 0 && newHeight <= maxBandHeight;
        if (deltaHeight < 0 || inBoundContidion) {
            int differences = newHeight - maxBandHeight;
            if (differences > 0) {
                deltaHeight -= differences;
            }
            request.setSizeDelta(new Dimension(0, (int)((double)deltaHeight * zoomMgr.getZoom())));
            request.setEditParts(this.getOperationSet());
            request.setResizeDirection(4);
            request.setLocation(this.getLocation());
            this.snapPoint(request);
            request.setLocation(this.getLocation());
        } else if (oldHeight < maxBandHeight) {
            request.setSizeDelta(new Dimension(0, (int)Math.ceil((double)(maxBandHeight - oldHeight) * zoomMgr.getZoom())));
            request.setEditParts(this.getOperationSet());
            request.setResizeDirection(1);
            this.snapPoint(request);
            request.setLocation(this.getLocation());
        } else {
            request.setSizeDelta(new Dimension(0, 0));
            request.setEditParts(this.getOperationSet());
            request.setResizeDirection(1);
            this.snapPoint(request);
            request.setLocation(this.getLocation());
        }
        return true;
    }

    protected boolean dragInProgress() {
        return this.isInState(36);
    }

    public boolean handleDragInProgress() {
        if (this.dragInProgress() && this.conditionallyUpdateSourceRequest()) {
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
            this.updateAutoexposeHelper();
        }
        return true;
    }

    class QueuedAutoexpose
    implements Runnable {
        QueuedAutoexpose() {
        }

        @Override
        public void run() {
            BandResizeTracker.this.doAutoexpose();
        }
    }
}

