/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.JSSScalableFreeformRootEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDesignDragable;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.swt.graphics.Point;

public class JSSCompoundResizeTracker
extends ResizeTracker {
    private ZoomManager zoomManager;

    public JSSCompoundResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    private ANode getLockableNode() {
        for (Object part : this.getOperationSet()) {
            ANode mainNode;
            EditPart ePart;
            if (!(part instanceof EditPart) || !((ePart = (EditPart)part).getModel() instanceof ANode) || (mainNode = JSSCompoundCommand.getMainNode((ANode)ePart.getModel())) == null) continue;
            return mainNode;
        }
        return null;
    }

    protected Command getCurrentCommand() {
        Object command = super.getCurrentCommand();
        if (!(command instanceof JSSCompoundCommand)) {
            if (command instanceof CompoundCommand) {
                CompoundCommand cc = (CompoundCommand)command;
                JSSCompoundCommand jsscc = new JSSCompoundCommand(cc, this.getLockableNode());
                command = jsscc;
            } else {
                JSSCompoundCommand jsscc = new JSSCompoundCommand(this.getLockableNode());
                jsscc.add((Command)command);
                command = jsscc;
            }
        }
        return command;
    }

    protected void showTargetFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            super.showTargetFeedback();
        }
    }

    protected void showSourceFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            super.showSourceFeedback();
        }
    }

    protected double getZoom() {
        if (this.zoomManager == null) {
            EditPartViewer viewer = this.getCurrentViewer();
            this.zoomManager = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
            if (this.zoomManager == null) {
                this.zoomManager = ((JSSScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            }
        }
        return this.zoomManager != null ? this.zoomManager.getZoom() : 1.0;
    }

    protected Request getSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)super.getSourceRequest();
        if (request.getEditParts() != null && request.getEditParts().size() > 0) {
            ANode node = null;
            Iterator iterator = request.getEditParts().iterator();
            if (iterator.hasNext()) {
                Object part = iterator.next();
                node = (ANode)((EditPart)part).getModel();
            }
            Point maximumSize = node.getAvailableSize();
            double zoom = 1.0 / this.getZoom();
            double sizeDelta_width = (double)request.getSizeDelta().width * zoom;
            double sizeDelta_height = (double)request.getSizeDelta().height * zoom;
            if (sizeDelta_width != 0.0 || sizeDelta_height != 0.0) {
                for (Object part : request.getEditParts()) {
                    double newHeight;
                    EditPart editPart = (EditPart)part;
                    Object model = editPart.getModel();
                    if (!(model instanceof IDesignDragable)) continue;
                    IDesignDragable element = (IDesignDragable)model;
                    Rectangle bounds = element.getJRBounds();
                    double newWidth = (double)bounds.width + sizeDelta_width;
                    if (Math.abs((double)bounds.x + newWidth) > (double)maximumSize.x) {
                        double delta = (double)(maximumSize.x - bounds.width - bounds.x) / zoom;
                        request.getSizeDelta().setWidth((int)Math.round(delta));
                    }
                    if (!(Math.abs((double)bounds.y + (newHeight = (double)bounds.height + sizeDelta_height)) > (double)maximumSize.y)) continue;
                    double delta = (double)(maximumSize.y - bounds.height - bounds.y) / zoom;
                    request.getSizeDelta().setHeight((int)Math.round(delta));
                }
            }
        }
        return request;
    }
}

