/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.background.BackgroundImageEditPart;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.CalloutElementResizableEditPolicy;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.PinMoveEditPolicy;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.editor.action.create.CreateElementAction;
import com.jaspersoft.studio.editor.gef.commands.SetConstraintCommand;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.AJDEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ElementResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.editor.gef.rulers.command.ChangeGuideCommand;
import com.jaspersoft.studio.editor.gef.util.CreateRequestUtil;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGuidebleElement;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.field.FieldUtils;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.variable.MVariable;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;

public class PageLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        return new Dimension(1, 1);
    }

    protected Command chainGuideAttachmentCommand(Request request, IGuidebleElement part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos != null) {
            int alignment = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalAttachment" : "SnapToGuides.VerticalAttachment");
            ChangeGuideCommand cgm = new ChangeGuideCommand(part, horizontal);
            cgm.setNewGuide(this.findGuideAt(guidePos, horizontal), alignment);
            result = result.chain((Command)cgm);
        }
        return result;
    }

    protected Command chainGuideDetachmentCommand(Request request, IGuidebleElement part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos == null) {
            result = result.chain((Command)new ChangeGuideCommand(part, horizontal));
        }
        return result;
    }

    protected ReportRulerGuide findGuideAt(int pos, boolean horizontal) {
        RulerProvider provider = (RulerProvider)this.getHost().getViewer().getProperty(horizontal ? "vertical ruler" : "horizontal ruler");
        return (ReportRulerGuide)provider.getGuideAt(pos);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        IFigure figure = child.getFigure();
        Rectangle bounds = figure.getBounds();
        if (figure instanceof HandleBounds) {
            bounds = ((HandleBounds)figure).getHandleBounds();
            --bounds.width;
            --bounds.height;
        }
        PrecisionRectangle rect = new PrecisionRectangle(bounds);
        figure.translateToAbsolute((Translatable)rect);
        rect = request.getTransformedRectangle((Rectangle)rect);
        figure.translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if (request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            Rectangle cons = this.getCurrentConstraintFor(child);
            if (cons != null) {
                rect.setSize(cons.width, cons.height);
            }
        } else {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                rect.width = minSize.width;
            }
            if (rect.height < minSize.height) {
                rect.height = minSize.height;
            }
        }
        return this.getConstraintFor((Rectangle)rect);
    }

    protected Point getLayoutOrigin() {
        IFigure container = this.getLayoutContainer();
        if (!(container.getLayoutManager() instanceof XYLayout)) {
            return container.getParent().getClientArea().getLocation();
        }
        return super.getLayoutOrigin();
    }

    protected Command getCreateCommand(CreateRequest request) {
        int index = CreateRequestUtil.getNewIndex(request);
        if (request.getType() == "create child" && this.getHost() instanceof AJDEditPart) {
            Rectangle constraint = this.adaptConstraint(this.getConstraintFor(request));
            ANode parent = (ANode)this.getHost().getModel();
            Rectangle copyconstraint = constraint.getCopy();
            if (request.getNewObject() instanceof Collection) {
                JSSCompoundCommand ccmd = new JSSCompoundCommand(parent);
                Collection objs = (Collection)request.getNewObject();
                boolean positionModifiedCreation = false;
                if (parent instanceof IGraphicElement && !this.isGraphicObjects(objs) && objs.size() > 1) {
                    positionModifiedCreation = true;
                    Rectangle rparent = ((IGraphicElement)((Object)parent)).getBounds();
                    int w = rparent.width / objs.size();
                    int rest = rparent.width - w * objs.size();
                    copyconstraint.setLocation(rparent.x + ReportPageFigure.PAGE_BORDER.left, copyconstraint.getLocation().y);
                    copyconstraint.width = w + rest;
                    for (Object it : objs) {
                        Command cmd = this.getCreateCommand(parent, it, copyconstraint.getCopy(), index, (Request)request);
                        if (cmd == null) continue;
                        ccmd.add(cmd);
                        copyconstraint.translate(w + rest, 0);
                        copyconstraint.width = w;
                        rest = 0;
                    }
                }
                if (!positionModifiedCreation) {
                    for (Object it : objs) {
                        Command cmd = this.getCreateCommand(parent, it, copyconstraint.getCopy(), index, (Request)request);
                        if (cmd == null) continue;
                        ccmd.add(cmd);
                        copyconstraint.translate(70, 0);
                    }
                }
                if (!ccmd.isEmpty()) {
                    return ccmd;
                }
            } else {
                if (request.getNewObject() instanceof CreateElementAction) {
                    CreateElementAction action = (CreateElementAction)((Object)request.getNewObject());
                    action.dropInto(this.getHost().getModel(), copyconstraint, -1);
                    action.run();
                    return action.getCommand();
                }
                return this.getCreateCommand(parent, request.getNewObject(), copyconstraint, index, (Request)request);
            }
        }
        return null;
    }

    private boolean isGraphicObjects(Collection<?> objs) {
        for (Object obj : objs) {
            if (obj instanceof MGraphicElement) continue;
            return false;
        }
        return true;
    }

    private IGraphicElement searchParent(ANode child) {
        if (child != null) {
            ANode parentModel = child.getParent();
            for (Object actualChild : this.getHost().getParent().getChildren()) {
                EditPart actualChildPart = (EditPart)actualChild;
                if (parentModel != actualChildPart.getModel()) continue;
                return (IGraphicElement)actualChildPart.getModel();
            }
        }
        return null;
    }

    protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
        if (obj instanceof ANode) {
            ANode aNode = (ANode)obj;
            if (aNode instanceof MGraphicElement) {
                Object value = aNode.getValue();
                if (value != null && value instanceof JRDesignGraphicElement) {
                    JRDesignGraphicElement jrDesignGraphicElement = (JRDesignGraphicElement)value;
                    try {
                        aNode = (ANode)aNode.getClass().newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        return null;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return null;
                    }
                    aNode.setValue(jrDesignGraphicElement.clone());
                    constraint.width = jrDesignGraphicElement.getWidth();
                    constraint.height = jrDesignGraphicElement.getHeight();
                }
                if (parent instanceof MBand) {
                    MBand band = (MBand)parent;
                    int x = constraint.x - band.getBounds().x;
                    int y = constraint.y - band.getBounds().y;
                    constraint.setLocation(x, y);
                } else if (parent instanceof MGraphicElement && !(parent instanceof IContainerLayout)) {
                    IGraphicElement container = this.searchParent(parent);
                    int x = constraint.x - container.getBounds().x;
                    int y = constraint.y - container.getBounds().y;
                    constraint.setLocation(x, y);
                    parent = (ANode)((Object)container);
                }
            } else if (aNode instanceof MField || aNode instanceof MParameter || aNode instanceof MVariable) {
                boolean adjustConstraints = true;
                if (request != null && request instanceof CreateRequest) {
                    CreateRequest createReq = (CreateRequest)request;
                    if (createReq.getNewObject() instanceof Collection) {
                        Collection objs = (Collection)createReq.getNewObject();
                        if (objs.size() <= 1) {
                            adjustConstraints = false;
                        }
                    } else {
                        adjustConstraints = false;
                    }
                }
                if (adjustConstraints) {
                    this.adjustConstraints(parent, constraint);
                }
            } else if (aNode instanceof MFields) {
                this.adjustConstraints(parent, constraint);
                CompoundCommand c = new CompoundCommand();
                List<MField> fields = FieldUtils.getFields((MFields)aNode);
                Rectangle rparent = ((IGraphicElement)((Object)parent)).getBounds();
                int w = rparent.width / fields.size();
                int rest = rparent.width - w * fields.size() - constraint.x;
                constraint.width = w + rest;
                for (MField f : fields) {
                    Command cmd = OutlineTreeEditPartFactory.getCreateCommand(parent, f, constraint.getCopy(), index, request, false);
                    if (cmd == null || !cmd.canExecute()) continue;
                    c.add(cmd);
                    constraint.translate(w + rest, 0);
                    constraint.width = w;
                    rest = 0;
                }
                if (!c.isEmpty()) {
                    return c;
                }
                return null;
            }
            return OutlineTreeEditPartFactory.getCreateCommand(parent, aNode, constraint, index, request, false);
        }
        return null;
    }

    private void adjustConstraints(ANode parent, Rectangle constraint) {
        if (parent.getChildren().isEmpty()) {
            if (parent instanceof MGraphicElement) {
                constraint.y = ((MGraphicElement)parent).getBounds().y;
            } else if (parent instanceof MBand) {
                constraint.y = ((MBand)parent).getBounds().y;
            }
        }
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (child instanceof CalloutEditPart) {
            return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
        }
        if (child instanceof PinEditPart) {
            return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
        }
        SetConstraintCommand cmd = new SetConstraintCommand();
        cmd.setContext((ANode)this.getHost().getModel(), (ANode)child.getModel(), this.adaptConstraint(constraint));
        return cmd;
    }

    protected Rectangle adaptConstraint(Object constraint) {
        Rectangle r = (Rectangle)constraint;
        Insets insets = this.getHostFigure().getInsets();
        r.translate(this.getLayoutOrigin().translate(-insets.left, -insets.top));
        return r;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Command result = this.createChangeConstraintCommand(child, constraint);
        if (child instanceof IContainerPart) {
            return result;
        }
        if (child.getModel() instanceof IGuidebleElement) {
            int edgeBeingResized;
            int alignment;
            Integer guidePos;
            IGuidebleElement part = (IGuidebleElement)child.getModel();
            if ((request.getResizeDirection() & 5) != 0) {
                guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
                if (guidePos != null) {
                    result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
                } else if (part.getHorizontalGuide() != null) {
                    alignment = part.getHorizontalGuide().getAlignment(part);
                    edgeBeingResized = 0;
                    edgeBeingResized = (request.getResizeDirection() & 1) != 0 ? -1 : 1;
                    if (alignment == edgeBeingResized) {
                        result = result.chain((Command)new ChangeGuideCommand(part, true));
                    }
                }
            }
            if ((request.getResizeDirection() & 0x18) != 0) {
                guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
                if (guidePos != null) {
                    result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
                } else if (part.getVerticalGuide() != null) {
                    alignment = part.getVerticalGuide().getAlignment(part);
                    edgeBeingResized = 0;
                    edgeBeingResized = (request.getResizeDirection() & 8) != 0 ? -1 : 1;
                    if (alignment == edgeBeingResized) {
                        result = result.chain((Command)new ChangeGuideCommand(part, false));
                    }
                }
            }
            if (request.getType().equals("move children") || request.getType().equals("align children")) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
                result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
                result = this.chainGuideDetachmentCommand((Request)request, part, result, true);
                result = this.chainGuideDetachmentCommand((Request)request, part, result, false);
            }
        }
        return result;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof IContainerPart) {
            return ((IContainerPart)child).getEditPolicy();
        }
        if (child instanceof FigureEditPart) {
            return new ElementResizableEditPolicy();
        }
        if (child instanceof CalloutEditPart) {
            return new CalloutElementResizableEditPolicy();
        }
        if (child instanceof PinEditPart) {
            return new PinMoveEditPolicy();
        }
        return super.createChildEditPolicy(child);
    }

    protected void decorateChild(EditPart child) {
        if (!(child instanceof BackgroundImageEditPart) && child.getEditPolicy((Object)"PrimaryDrag Policy") == null) {
            EditPolicy policy = this.createChildEditPolicy(child);
            child.installEditPolicy((Object)"PrimaryDrag Policy", policy);
        }
    }
}

