/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.editPolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.JSSScalableFreeformRootEditPart;
import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.editor.gef.parts.band.BandEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IDesignDragable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class SearchParentDragTracker
extends DragEditPartsTracker {
    private static final int DEFAULT_EXPOSE_THRESHOLD = 50;
    private static final String STRAIGHT_DRAG_KEY_ID = "com.jaspersoft.studio.editor.straightmovment";
    private static final String NO_SNAPPING_DRAG_KEY_ID = "com.jaspersoft.studio.editor.straightmovment.nosnapping";
    protected static final String MOVE_CHILD_KEY_ID = "com.jaspersoft.studio.editor.enforcechangeparent";
    protected static final String KEEP_PARENT_KEY_ID = "com.jaspersoft.studio.editor.enforcekeepparent";
    private HashSet<INode> selectionHierarchy = null;
    private ZoomManager zoomManager;
    private boolean keepParentDrag = false;
    private MOUSE_DIRECTION firstMovment = MOUSE_DIRECTION.UNDEFINED;

    public SearchParentDragTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected boolean handleDragInProgress() {
        Command command;
        if (this.getAutoexposeHelper() == null) {
            Viewport port = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport();
            this.setAutoexposeHelper(new DragAutoExpose(port, 50));
        }
        if (!(this.isInState(0x40000000) || (command = this.getCurrentCommand()) != null && command.canExecute())) {
            this.eraseSourceFeedback();
        }
        return super.handleDragInProgress();
    }

    protected String getDebugName() {
        return "SameParentDragTracker:" + this.getCommandName();
    }

    private EditPart searchContainer(EditPart child) {
        if (child != null) {
            ANode parentModel = ((ANode)child.getModel()).getParent();
            if (parentModel == null) {
                return null;
            }
            if (child instanceof ReportPageEditPart) {
                ReportPageEditPart rootPart = (ReportPageEditPart)child;
                ChangeBoundsRequest req = (ChangeBoundsRequest)this.getTargetRequest();
                FigureEditPart lastBand = null;
                FigureEditPart firstBand = null;
                for (Object element : rootPart.getChildren()) {
                    if (!(element instanceof BandEditPart)) continue;
                    FigureEditPart actualChildPart = (FigureEditPart)element;
                    if (firstBand == null) {
                        firstBand = actualChildPart;
                    }
                    lastBand = actualChildPart;
                    Rectangle bounds = actualChildPart.getFigure().getBounds();
                    if (bounds.y > req.getLocation().y || req.getLocation().y > bounds.y + bounds.height) continue;
                    return actualChildPart;
                }
                if (firstBand != null && req.getLocation().y < firstBand.getFigure().getBounds().y) {
                    return firstBand;
                }
                if (lastBand != null) {
                    Rectangle bounds = lastBand.getFigure().getBounds();
                    if (req.getLocation().y > bounds.y + bounds.height) {
                        return lastBand;
                    }
                }
                return null;
            }
            if (this.selectionHierarchy != null) {
                while (this.selectionHierarchy.contains(parentModel)) {
                    if ((parentModel = parentModel.getParent()) != null) continue;
                    return null;
                }
            }
            for (Object actualChild : child.getParent().getChildren()) {
                EditPart actualChildPart = (EditPart)actualChild;
                if (parentModel != actualChildPart.getModel()) continue;
                return actualChildPart;
            }
        }
        return null;
    }

    private EditPart getParent(EditPart child) {
        if (child != null) {
            ANode parentModel = ((ANode)child.getModel()).getParent();
            if (parentModel == null) {
                return null;
            }
            for (Object actualChild : child.getParent().getChildren()) {
                EditPart actualChildPart = (EditPart)actualChild;
                if (parentModel != actualChildPart.getModel()) continue;
                return actualChildPart;
            }
        }
        return null;
    }

    private HashSet<INode> getSelectionDesendent() {
        HashSet<INode> result = new HashSet<INode>();
        INode lastParent = null;
        for (Object part : this.getCurrentViewer().getSelectedEditParts()) {
            if (!(part instanceof EditPart)) continue;
            EditPart ep = (EditPart)part;
            INode model = (INode)ep.getModel();
            INode currentParent = model.getParent();
            if (!this.keepParentDrag) {
                if (currentParent instanceof MFrame) {
                    this.keepParentDrag = true;
                } else if (lastParent == null) {
                    lastParent = currentParent;
                } else if (currentParent != lastParent) {
                    this.keepParentDrag = true;
                }
            }
            result.add(model);
            if (!(model instanceof IContainer)) continue;
            this.getSelectionDesendentRecursive(model.getChildren(), result);
        }
        return result;
    }

    private void getSelectionDesendentRecursive(List<INode> children, HashSet<INode> foundedElements) {
        for (INode child : children) {
            foundedElements.add(child);
            if (!(child instanceof IContainer)) continue;
            this.getSelectionDesendentRecursive(child.getChildren(), foundedElements);
        }
    }

    private void removeNestedElements(MFrame parent, List<EditPart> actualSelection) {
        int i = 0;
        while (i < actualSelection.size()) {
            ANode model;
            EditPart element = actualSelection.get(i);
            if (element != null && (model = (ANode)element.getModel()).getParent() == parent) {
                if (model instanceof MFrame) {
                    this.removeNestedElements((MFrame)model, actualSelection);
                }
                actualSelection.set(i, null);
            }
            ++i;
        }
    }

    protected List createOperationSet() {
        ArrayList<EditPart> selectedElements = new ArrayList<EditPart>();
        for (Object part : this.getCurrentViewer().getSelectedEditParts()) {
            if (!(((EditPart)part).getModel() instanceof IDesignDragable)) continue;
            selectedElements.add((EditPart)part);
        }
        for (EditPart element : selectedElements) {
            if (element == null || !(element.getModel() instanceof MFrame)) continue;
            this.removeNestedElements((MFrame)element.getModel(), selectedElements);
        }
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (EditPart element : selectedElements) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    protected boolean handleDragStarted() {
        this.selectionHierarchy = this.getSelectionDesendent();
        return super.handleDragStarted();
    }

    private ANode getLockableNode() {
        for (Object part : this.getOperationSet()) {
            ANode mainNode;
            EditPart ePart;
            if (!(part instanceof EditPart) || !((ePart = (EditPart)part).getModel() instanceof ANode) || (mainNode = JSSCompoundCommand.getMainNode((ANode)ePart.getModel())) == null) continue;
            return mainNode;
        }
        return null;
    }

    protected Command getCurrentCommand() {
        Object command = super.getCurrentCommand();
        if (!(command instanceof JSSCompoundCommand)) {
            if (command instanceof CompoundCommand) {
                CompoundCommand cc = (CompoundCommand)command;
                JSSCompoundCommand jsscc = new JSSCompoundCommand(cc, this.getLockableNode());
                command = jsscc;
            } else {
                JSSCompoundCommand jsscc = new JSSCompoundCommand(this.getLockableNode());
                jsscc.add((Command)command);
                command = jsscc;
            }
        }
        return command;
    }

    protected Command getCommand() {
        boolean useOldBheavior = BindingsPreferencePersistence.isPressed(MOVE_CHILD_KEY_ID);
        if (useOldBheavior) {
            return super.getCommand();
        }
        boolean forceKeepParent = BindingsPreferencePersistence.isPressed(KEEP_PARENT_KEY_ID);
        if (this.keepParentDrag || forceKeepParent) {
            return this.getKeepParentCommand();
        }
        return super.getCommand();
    }

    private Command getKeepParentCommand() {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Drag Object Tracker");
        Iterator iter = this.getOperationSet().iterator();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setType((Object)"move children");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            request.setEditParts(editPart);
            EditPart parent = this.getParent(editPart);
            if (parent == null) continue;
            command.add(parent.getCommand((Request)request));
        }
        return command.unwrap();
    }

    protected void showTargetFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            boolean useOldBheavior = BindingsPreferencePersistence.isPressed(MOVE_CHILD_KEY_ID);
            boolean forceKeepParent = BindingsPreferencePersistence.isPressed(KEEP_PARENT_KEY_ID);
            if (!forceKeepParent && !this.keepParentDrag || useOldBheavior) {
                super.showTargetFeedback();
            }
        }
    }

    protected void showSourceFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            super.showSourceFeedback();
        }
    }

    protected void performDrag() {
        super.performDrag();
        this.selectionHierarchy = null;
        this.firstMovment = MOUSE_DIRECTION.UNDEFINED;
        this.keepParentDrag = false;
    }

    protected EditPart getTargetEditPart() {
        EditPart target = super.getTargetEditPart();
        return this.getTargetEditPart(target);
    }

    protected EditPart getTargetEditPart(EditPart target) {
        EditPart parent = null;
        if (!(target instanceof IContainer) || this.selectionHierarchy != null && this.selectionHierarchy.contains(target.getModel())) {
            parent = this.searchContainer(target);
        }
        EditPart result = parent != null ? parent : target;
        return result;
    }

    protected double getZoom() {
        if (this.zoomManager == null) {
            EditPartViewer viewer = this.getCurrentViewer();
            this.zoomManager = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
            if (this.zoomManager == null) {
                this.zoomManager = ((JSSScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            }
        }
        return this.zoomManager != null ? this.zoomManager.getZoom() : 1.0;
    }

    protected Request getTargetRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)super.getTargetRequest();
        if (request.getEditParts() != null && request.getEditParts().size() > 0) {
            ANode node = null;
            Iterator iterator = request.getEditParts().iterator();
            if (iterator.hasNext()) {
                Object part = iterator.next();
                node = (ANode)((EditPart)part).getModel();
            }
            org.eclipse.swt.graphics.Point maximumSize = node.getAvailableSize();
            double zoom = 1.0 / this.getZoom();
            double moveDelta_x = (double)request.getMoveDelta().x * zoom;
            double moveDelta_y = (double)request.getMoveDelta().y * zoom;
            if (moveDelta_x != 0.0 || moveDelta_y != 0.0) {
                for (Object part : request.getEditParts()) {
                    double delta;
                    double newY;
                    double delta2;
                    IDesignDragable gElement = (IDesignDragable)((EditPart)part).getModel();
                    Rectangle bounds = gElement.getJRBounds();
                    double newX = (double)bounds.x + moveDelta_x;
                    if (newX >= 0.0) {
                        if ((double)Math.abs(bounds.width) + newX > (double)maximumSize.x) {
                            delta2 = (double)(maximumSize.x - bounds.width - bounds.x) / zoom;
                            request.getMoveDelta().setX((int)Math.round(delta2));
                        }
                    } else if (Math.abs(newX) > (double)maximumSize.x) {
                        delta2 = (double)(-maximumSize.x - bounds.x) / zoom;
                        request.getMoveDelta().setX((int)Math.round(delta2));
                    }
                    if ((newY = (double)bounds.y + moveDelta_y) > 0.0) {
                        if (!((double)Math.abs(bounds.height) + newY > (double)maximumSize.y)) continue;
                        delta = (double)(maximumSize.y - bounds.height - bounds.y) / zoom;
                        request.getMoveDelta().setY((int)Math.round(delta));
                        continue;
                    }
                    if (!(Math.abs(newY) > (double)maximumSize.y)) continue;
                    delta = (double)(-maximumSize.y - bounds.y) / zoom;
                    request.getMoveDelta().setY((int)Math.round(delta));
                }
            }
        }
        return request;
    }

    protected boolean isCloneActive() {
        return false;
    }

    protected void updateTargetRequest() {
        this.repairStartLocation();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        Dimension delta = this.getDragMoveDelta();
        request.setSnapToEnabled(!BindingsPreferencePersistence.isPressed(NO_SNAPPING_DRAG_KEY_ID));
        request.setConstrainedMove(BindingsPreferencePersistence.isPressed(STRAIGHT_DRAG_KEY_ID));
        if (request.isConstrainedMove()) {
            int x = Math.abs(delta.width);
            int y = Math.abs(delta.height);
            if (x > 10 && x > y && this.firstMovment == MOUSE_DIRECTION.UNDEFINED) {
                this.firstMovment = MOUSE_DIRECTION.HORIZONTAL;
            }
            if (y > 10 && y > x && this.firstMovment == MOUSE_DIRECTION.UNDEFINED) {
                this.firstMovment = MOUSE_DIRECTION.VERTICAL;
            }
            if (this.firstMovment != MOUSE_DIRECTION.UNDEFINED) {
                if (this.firstMovment == MOUSE_DIRECTION.VERTICAL) {
                    delta.width = 0;
                } else {
                    delta.height = 0;
                }
            }
        } else {
            this.firstMovment = MOUSE_DIRECTION.UNDEFINED;
        }
        Point moveDelta = new Point(delta.width, delta.height);
        request.getExtendedData().clear();
        request.setMoveDelta(moveDelta);
        this.snapPoint(request);
        request.setLocation(this.getLocation());
        request.setType((Object)this.getCommandName());
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            if (editPart != null) {
                editPart = this.getTargetEditPart(editPart);
            }
            boolean changed = super.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }

    private class DragAutoExpose
    implements AutoexposeHelper {
        private Viewport port;
        private long lastStepTime = 0L;
        private int threshold;

        public DragAutoExpose(Viewport port, int threshold) {
            this.port = port;
            this.threshold = threshold;
        }

        public DragAutoExpose(Viewport port) {
            this(port, 50);
        }

        public boolean detect(Point where) {
            this.lastStepTime = 0L;
            Rectangle rect = Rectangle.SINGLETON;
            this.port.getClientArea(rect);
            this.port.translateToParent((Translatable)rect);
            this.port.translateToAbsolute((Translatable)rect);
            boolean needChange = false;
            if (where.x >= rect.width - this.threshold) {
                needChange = true;
            }
            if (where.y >= rect.height - this.threshold) {
                needChange = true;
            }
            if (where.x < this.threshold) {
                needChange = true;
            }
            if (where.y < this.threshold) {
                needChange = true;
            }
            return needChange;
        }

        private boolean needToWait() {
            long difference;
            int scrollOffset = 0;
            if (this.lastStepTime == 0L) {
                this.lastStepTime = System.currentTimeMillis();
            }
            if ((difference = System.currentTimeMillis() - this.lastStepTime) > 0L) {
                scrollOffset = (int)difference / 3;
                this.lastStepTime = System.currentTimeMillis();
            }
            return scrollOffset == 0;
        }

        public boolean step(Point where) {
            Rectangle rect = Rectangle.SINGLETON;
            this.port.getClientArea(rect);
            this.port.translateToParent((Translatable)rect);
            this.port.translateToAbsolute((Translatable)rect);
            Point loc = this.port.getViewLocation();
            Point targetloc = this.port.getViewLocation();
            if (this.needToWait()) {
                return true;
            }
            if (where.x >= rect.width - this.threshold) {
                targetloc.x += this.threshold * 2;
            }
            if (where.y >= rect.height - this.threshold) {
                targetloc.y += this.threshold * 2;
            }
            if (where.x < this.threshold) {
                targetloc.x -= this.threshold * 2;
            }
            if (where.y < this.threshold) {
                targetloc.y -= this.threshold * 2;
            }
            if (!loc.equals((Object)targetloc)) {
                this.port.setViewLocation(targetloc);
                SearchParentDragTracker.this.updateTargetUnderMouse();
                return true;
            }
            return false;
        }
    }

    private static enum MOUSE_DIRECTION {
        HORIZONTAL,
        VERTICAL,
        UNDEFINED;

    }
}

