/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.MoveHandleLocator;

public class CellMoveHandleLocator
extends MoveHandleLocator {
    private GraphicalEditPart editPart;

    public CellMoveHandleLocator(GraphicalEditPart editPart) {
        super(editPart.getFigure());
        this.editPart = editPart;
    }

    public void relocate(IFigure target) {
        super.relocate(target);
        if (this.editPart instanceof IContainerPart) {
            Rectangle b = target.getBounds();
            Dimension d = ((IContainerPart)this.editPart).getContaierSize();
            ZoomManager zm = (ZoomManager)this.editPart.getViewer().getProperty(ZoomManager.class.toString());
            double zoom = zm.getZoom();
            b.y = (int)Math.floor(10.0 * zoom) - 10 - 3;
            b.x = (int)Math.floor(10.0 * zoom) - 10 - 3;
            b.height = d.height;
            b.width = d.width;
            PrecisionRectangle copy = new PrecisionRectangle(b.getCopy());
            this.getReference().translateToAbsolute((Translatable)copy);
            target.translateToRelative((Translatable)copy);
            b.height = 26 + copy.height;
            b.width = 26 + copy.width;
            target.setBounds(b);
        }
    }
}

